/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ReleaseHostsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ReleaseHostsRequestMarshaller
implements Marshaller<Request<ReleaseHostsRequest>, ReleaseHostsRequest> {
    @Override
    public Request<ReleaseHostsRequest> marshall(ReleaseHostsRequest releaseHostsRequest) {
        if (releaseHostsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ReleaseHostsRequest> request = new DefaultRequest<ReleaseHostsRequest>(releaseHostsRequest, "AmazonEC2");
        request.addParameter("Action", "ReleaseHosts");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList releaseHostsRequestHostIdsList = (SdkInternalList)releaseHostsRequest.getHostIds();
        if (!releaseHostsRequestHostIdsList.isEmpty() || !releaseHostsRequestHostIdsList.isAutoConstruct()) {
            int hostIdsListIndex = 1;
            for (String releaseHostsRequestHostIdsListValue : releaseHostsRequestHostIdsList) {
                if (releaseHostsRequestHostIdsListValue != null) {
                    request.addParameter("HostId." + hostIdsListIndex, StringUtils.fromString(releaseHostsRequestHostIdsListValue));
                }
                ++hostIdsListIndex;
            }
        }
        return request;
    }
}

