/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.DescribeFleetCapacityRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class DescribeFleetCapacityRequestMarshaller
implements Marshaller<Request<DescribeFleetCapacityRequest>, DescribeFleetCapacityRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeFleetCapacityRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeFleetCapacityRequest> marshall(DescribeFleetCapacityRequest describeFleetCapacityRequest) {
        if (describeFleetCapacityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeFleetCapacityRequest> request = new DefaultRequest<DescribeFleetCapacityRequest>(describeFleetCapacityRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.DescribeFleetCapacity");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> fleetIdsList = describeFleetCapacityRequest.getFleetIds();
            if (fleetIdsList != null) {
                jsonGenerator.writeFieldName("FleetIds");
                jsonGenerator.writeStartArray();
                for (String fleetIdsListValue : fleetIdsList) {
                    if (fleetIdsListValue == null) continue;
                    jsonGenerator.writeValue(fleetIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeFleetCapacityRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeFleetCapacityRequest.getLimit());
            }
            if (describeFleetCapacityRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeFleetCapacityRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

