/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.CreateDeploymentConfigRequest;
import com.amazonaws.services.codedeploy.model.transform.MinimumHealthyHostsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateDeploymentConfigRequestMarshaller
implements Marshaller<Request<CreateDeploymentConfigRequest>, CreateDeploymentConfigRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateDeploymentConfigRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateDeploymentConfigRequest> marshall(CreateDeploymentConfigRequest createDeploymentConfigRequest) {
        if (createDeploymentConfigRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDeploymentConfigRequest> request = new DefaultRequest<CreateDeploymentConfigRequest>(createDeploymentConfigRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.CreateDeploymentConfig");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createDeploymentConfigRequest.getDeploymentConfigName() != null) {
                jsonGenerator.writeFieldName("deploymentConfigName").writeValue(createDeploymentConfigRequest.getDeploymentConfigName());
            }
            if (createDeploymentConfigRequest.getMinimumHealthyHosts() != null) {
                jsonGenerator.writeFieldName("minimumHealthyHosts");
                MinimumHealthyHostsJsonMarshaller.getInstance().marshall(createDeploymentConfigRequest.getMinimumHealthyHosts(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

