/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.EnableTopicRuleRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class EnableTopicRuleRequestMarshaller
implements Marshaller<Request<EnableTopicRuleRequest>, EnableTopicRuleRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public EnableTopicRuleRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<EnableTopicRuleRequest> marshall(EnableTopicRuleRequest enableTopicRuleRequest) {
        if (enableTopicRuleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<EnableTopicRuleRequest> request = new DefaultRequest<EnableTopicRuleRequest>(enableTopicRuleRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/rules/{ruleName}/enable";
        uriResourcePath = uriResourcePath.replace("{ruleName}", enableTopicRuleRequest.getRuleName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(enableTopicRuleRequest.getRuleName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

