/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.Action;
import com.amazonaws.services.elasticloadbalancingv2.model.ModifyRuleRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.RuleCondition;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyRuleRequestMarshaller
implements Marshaller<Request<ModifyRuleRequest>, ModifyRuleRequest> {
    @Override
    public Request<ModifyRuleRequest> marshall(ModifyRuleRequest modifyRuleRequest) {
        List<Action> actionsList;
        List<RuleCondition> conditionsList;
        if (modifyRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyRuleRequest> request = new DefaultRequest<ModifyRuleRequest>(modifyRuleRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ModifyRule");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyRuleRequest.getRuleArn() != null) {
            request.addParameter("RuleArn", StringUtils.fromString(modifyRuleRequest.getRuleArn()));
        }
        if ((conditionsList = modifyRuleRequest.getConditions()) != null) {
            if (conditionsList.isEmpty()) {
                request.addParameter("Conditions", "");
            } else {
                int conditionsListIndex = 1;
                for (RuleCondition conditionsListValue : conditionsList) {
                    List<String> valuesList;
                    if (conditionsListValue.getField() != null) {
                        request.addParameter("Conditions.member." + conditionsListIndex + ".Field", StringUtils.fromString(conditionsListValue.getField()));
                    }
                    if ((valuesList = conditionsListValue.getValues()) != null) {
                        if (valuesList.isEmpty()) {
                            request.addParameter("Conditions.member." + conditionsListIndex + ".Values", "");
                        } else {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Conditions.member." + conditionsListIndex + ".Values.member." + valuesListIndex, StringUtils.fromString(valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        }
                    }
                    ++conditionsListIndex;
                }
            }
        }
        if ((actionsList = modifyRuleRequest.getActions()) != null) {
            if (actionsList.isEmpty()) {
                request.addParameter("Actions", "");
            } else {
                int actionsListIndex = 1;
                for (Action actionsListValue : actionsList) {
                    if (actionsListValue.getType() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".Type", StringUtils.fromString(actionsListValue.getType()));
                    }
                    if (actionsListValue.getTargetGroupArn() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".TargetGroupArn", StringUtils.fromString(actionsListValue.getTargetGroupArn()));
                    }
                    ++actionsListIndex;
                }
            }
        }
        return request;
    }
}

