/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeLoadBalancersRequestMarshaller
implements Marshaller<Request<DescribeLoadBalancersRequest>, DescribeLoadBalancersRequest> {
    @Override
    public Request<DescribeLoadBalancersRequest> marshall(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        List<String> namesList;
        if (describeLoadBalancersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeLoadBalancersRequest> request = new DefaultRequest<DescribeLoadBalancersRequest>(describeLoadBalancersRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeLoadBalancers");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> loadBalancerArnsList = describeLoadBalancersRequest.getLoadBalancerArns();
        if (loadBalancerArnsList != null) {
            if (loadBalancerArnsList.isEmpty()) {
                request.addParameter("LoadBalancerArns", "");
            } else {
                int loadBalancerArnsListIndex = 1;
                for (String loadBalancerArnsListValue : loadBalancerArnsList) {
                    if (loadBalancerArnsListValue != null) {
                        request.addParameter("LoadBalancerArns.member." + loadBalancerArnsListIndex, StringUtils.fromString(loadBalancerArnsListValue));
                    }
                    ++loadBalancerArnsListIndex;
                }
            }
        }
        if ((namesList = describeLoadBalancersRequest.getNames()) != null) {
            if (namesList.isEmpty()) {
                request.addParameter("Names", "");
            } else {
                int namesListIndex = 1;
                for (String namesListValue : namesList) {
                    if (namesListValue != null) {
                        request.addParameter("Names.member." + namesListIndex, StringUtils.fromString(namesListValue));
                    }
                    ++namesListIndex;
                }
            }
        }
        if (describeLoadBalancersRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeLoadBalancersRequest.getMarker()));
        }
        if (describeLoadBalancersRequest.getPageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger(describeLoadBalancersRequest.getPageSize()));
        }
        return request;
    }
}

