/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AcceptReservedInstancesExchangeQuoteRequest;
import com.amazonaws.services.ec2.model.TargetConfigurationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AcceptReservedInstancesExchangeQuoteRequestMarshaller
implements Marshaller<Request<AcceptReservedInstancesExchangeQuoteRequest>, AcceptReservedInstancesExchangeQuoteRequest> {
    @Override
    public Request<AcceptReservedInstancesExchangeQuoteRequest> marshall(AcceptReservedInstancesExchangeQuoteRequest acceptReservedInstancesExchangeQuoteRequest) {
        SdkInternalList targetConfigurationsList;
        if (acceptReservedInstancesExchangeQuoteRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AcceptReservedInstancesExchangeQuoteRequest> request = new DefaultRequest<AcceptReservedInstancesExchangeQuoteRequest>(acceptReservedInstancesExchangeQuoteRequest, "AmazonEC2");
        request.addParameter("Action", "AcceptReservedInstancesExchangeQuote");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList reservedInstanceIdsList = (SdkInternalList)acceptReservedInstancesExchangeQuoteRequest.getReservedInstanceIds();
        if (!reservedInstanceIdsList.isEmpty() || !reservedInstanceIdsList.isAutoConstruct()) {
            int reservedInstanceIdsListIndex = 1;
            for (String reservedInstanceIdsListValue : reservedInstanceIdsList) {
                if (reservedInstanceIdsListValue != null) {
                    request.addParameter("ReservedInstanceId." + reservedInstanceIdsListIndex, StringUtils.fromString(reservedInstanceIdsListValue));
                }
                ++reservedInstanceIdsListIndex;
            }
        }
        if (!(targetConfigurationsList = (SdkInternalList)acceptReservedInstancesExchangeQuoteRequest.getTargetConfigurations()).isEmpty() || !targetConfigurationsList.isAutoConstruct()) {
            int targetConfigurationsListIndex = 1;
            for (TargetConfigurationRequest targetConfigurationsListValue : targetConfigurationsList) {
                if (targetConfigurationsListValue.getOfferingId() != null) {
                    request.addParameter("TargetConfiguration." + targetConfigurationsListIndex + ".OfferingId", StringUtils.fromString(targetConfigurationsListValue.getOfferingId()));
                }
                if (targetConfigurationsListValue.getInstanceCount() != null) {
                    request.addParameter("TargetConfiguration." + targetConfigurationsListIndex + ".InstanceCount", StringUtils.fromInteger(targetConfigurationsListValue.getInstanceCount()));
                }
                ++targetConfigurationsListIndex;
            }
        }
        return request;
    }
}

