/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.DeprecateThingTypeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeprecateThingTypeRequestMarshaller
implements Marshaller<Request<DeprecateThingTypeRequest>, DeprecateThingTypeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeprecateThingTypeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeprecateThingTypeRequest> marshall(DeprecateThingTypeRequest deprecateThingTypeRequest) {
        if (deprecateThingTypeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeprecateThingTypeRequest> request = new DefaultRequest<DeprecateThingTypeRequest>(deprecateThingTypeRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/thing-types/{thingTypeName}/deprecate";
        uriResourcePath = uriResourcePath.replace("{thingTypeName}", deprecateThingTypeRequest.getThingTypeName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deprecateThingTypeRequest.getThingTypeName()), false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deprecateThingTypeRequest.getUndoDeprecate() != null) {
                jsonGenerator.writeFieldName("undoDeprecate").writeValue(deprecateThingTypeRequest.getUndoDeprecate());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

