/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;

public interface DynamoDBTypeConverter<S, T> {
    public S convert(T var1);

    public T unconvert(S var1);

    public static class NullSafeConverter<S, T>
    extends DelegateConverter<S, T> {
        public NullSafeConverter(DynamoDBTypeConverter<S, T> delegate) {
            super(delegate);
        }

        @Override
        public S convert(T object) {
            return object == null ? null : (S)super.convert(object);
        }

        @Override
        public T unconvert(S object) {
            return object == null ? null : (T)super.unconvert(object);
        }
    }

    public static abstract class DelegateConverter<S, T>
    extends AbstractConverter<S, T> {
        private final DynamoDBTypeConverter<S, T> delegate;

        public DelegateConverter(DynamoDBTypeConverter<S, T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public S convert(T object) {
            return this.delegate.convert(object);
        }

        @Override
        public T unconvert(S object) {
            return this.delegate.unconvert(object);
        }
    }

    public static class ExtendedConverter<S, U, T>
    extends AbstractConverter<S, T> {
        private final DynamoDBTypeConverter<S, U> source;
        private final DynamoDBTypeConverter<U, T> target;

        public ExtendedConverter(DynamoDBTypeConverter<S, U> source, DynamoDBTypeConverter<U, T> target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public S convert(T o) {
            return this.source.convert(this.target.convert(o));
        }

        @Override
        public T unconvert(S o) {
            return this.target.unconvert(this.source.unconvert(o));
        }
    }

    @SdkInternalApi
    public static abstract class AbstractConverter<S, T>
    implements DynamoDBTypeConverter<S, T> {
        protected AbstractConverter() {
        }

        public static <S, U, T> DynamoDBTypeConverter<S, T> join(DynamoDBTypeConverter<S, U> source, DynamoDBTypeConverter<U, T> target) {
            return new ExtendedConverter<S, U, T>(AbstractConverter.nullSafe(source), AbstractConverter.nullSafe(target));
        }

        public static <S, T> DynamoDBTypeConverter<S, T> nullSafe(DynamoDBTypeConverter<S, T> converter) {
            return new NullSafeConverter<S, T>(converter);
        }

        public <U> DynamoDBTypeConverter<S, U> join(DynamoDBTypeConverter<T, U> target) {
            return AbstractConverter.join(this, target);
        }

        public DynamoDBTypeConverter<S, T> nullSafe() {
            return AbstractConverter.nullSafe(this);
        }
    }
}

