/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.Matcher;
import com.amazonaws.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyTargetGroupRequestMarshaller
implements Marshaller<Request<ModifyTargetGroupRequest>, ModifyTargetGroupRequest> {
    @Override
    public Request<ModifyTargetGroupRequest> marshall(ModifyTargetGroupRequest modifyTargetGroupRequest) {
        Matcher matcher;
        if (modifyTargetGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyTargetGroupRequest> request = new DefaultRequest<ModifyTargetGroupRequest>(modifyTargetGroupRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ModifyTargetGroup");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyTargetGroupRequest.getTargetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringUtils.fromString(modifyTargetGroupRequest.getTargetGroupArn()));
        }
        if (modifyTargetGroupRequest.getHealthCheckProtocol() != null) {
            request.addParameter("HealthCheckProtocol", StringUtils.fromString(modifyTargetGroupRequest.getHealthCheckProtocol()));
        }
        if (modifyTargetGroupRequest.getHealthCheckPort() != null) {
            request.addParameter("HealthCheckPort", StringUtils.fromString(modifyTargetGroupRequest.getHealthCheckPort()));
        }
        if (modifyTargetGroupRequest.getHealthCheckPath() != null) {
            request.addParameter("HealthCheckPath", StringUtils.fromString(modifyTargetGroupRequest.getHealthCheckPath()));
        }
        if (modifyTargetGroupRequest.getHealthCheckIntervalSeconds() != null) {
            request.addParameter("HealthCheckIntervalSeconds", StringUtils.fromInteger(modifyTargetGroupRequest.getHealthCheckIntervalSeconds()));
        }
        if (modifyTargetGroupRequest.getHealthCheckTimeoutSeconds() != null) {
            request.addParameter("HealthCheckTimeoutSeconds", StringUtils.fromInteger(modifyTargetGroupRequest.getHealthCheckTimeoutSeconds()));
        }
        if (modifyTargetGroupRequest.getHealthyThresholdCount() != null) {
            request.addParameter("HealthyThresholdCount", StringUtils.fromInteger(modifyTargetGroupRequest.getHealthyThresholdCount()));
        }
        if (modifyTargetGroupRequest.getUnhealthyThresholdCount() != null) {
            request.addParameter("UnhealthyThresholdCount", StringUtils.fromInteger(modifyTargetGroupRequest.getUnhealthyThresholdCount()));
        }
        if ((matcher = modifyTargetGroupRequest.getMatcher()) != null && matcher.getHttpCode() != null) {
            request.addParameter("Matcher.HttpCode", StringUtils.fromString(matcher.getHttpCode()));
        }
        return request;
    }
}

