/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.DescribePoliciesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribePoliciesRequestMarshaller
implements Marshaller<Request<DescribePoliciesRequest>, DescribePoliciesRequest> {
    @Override
    public Request<DescribePoliciesRequest> marshall(DescribePoliciesRequest describePoliciesRequest) {
        SdkInternalList policyTypesList;
        SdkInternalList policyNamesList;
        if (describePoliciesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribePoliciesRequest> request = new DefaultRequest<DescribePoliciesRequest>(describePoliciesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribePolicies");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describePoliciesRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(describePoliciesRequest.getAutoScalingGroupName()));
        }
        if (!(policyNamesList = (SdkInternalList)describePoliciesRequest.getPolicyNames()).isEmpty() || !policyNamesList.isAutoConstruct()) {
            int policyNamesListIndex = 1;
            for (String policyNamesListValue : policyNamesList) {
                if (policyNamesListValue != null) {
                    request.addParameter("PolicyNames.member." + policyNamesListIndex, StringUtils.fromString(policyNamesListValue));
                }
                ++policyNamesListIndex;
            }
        }
        if (!(policyTypesList = (SdkInternalList)describePoliciesRequest.getPolicyTypes()).isEmpty() || !policyTypesList.isAutoConstruct()) {
            int policyTypesListIndex = 1;
            for (String policyTypesListValue : policyTypesList) {
                if (policyTypesListValue != null) {
                    request.addParameter("PolicyTypes.member." + policyTypesListIndex, StringUtils.fromString(policyTypesListValue));
                }
                ++policyTypesListIndex;
            }
        }
        if (describePoliciesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describePoliciesRequest.getNextToken()));
        }
        if (describePoliciesRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describePoliciesRequest.getMaxRecords()));
        }
        return request;
    }
}

