/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.InputSchemaUpdate;
import com.amazonaws.services.kinesisanalytics.model.RecordColumn;
import com.amazonaws.services.kinesisanalytics.model.transform.RecordColumnJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.RecordFormatJsonMarshaller;
import java.util.List;

public class InputSchemaUpdateJsonMarshaller {
    private static InputSchemaUpdateJsonMarshaller instance;

    public void marshall(InputSchemaUpdate inputSchemaUpdate, StructuredJsonGenerator jsonGenerator) {
        if (inputSchemaUpdate == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<RecordColumn> recordColumnUpdatesList;
            jsonGenerator.writeStartObject();
            if (inputSchemaUpdate.getRecordFormatUpdate() != null) {
                jsonGenerator.writeFieldName("RecordFormatUpdate");
                RecordFormatJsonMarshaller.getInstance().marshall(inputSchemaUpdate.getRecordFormatUpdate(), jsonGenerator);
            }
            if (inputSchemaUpdate.getRecordEncodingUpdate() != null) {
                jsonGenerator.writeFieldName("RecordEncodingUpdate").writeValue(inputSchemaUpdate.getRecordEncodingUpdate());
            }
            if ((recordColumnUpdatesList = inputSchemaUpdate.getRecordColumnUpdates()) != null) {
                jsonGenerator.writeFieldName("RecordColumnUpdates");
                jsonGenerator.writeStartArray();
                for (RecordColumn recordColumnUpdatesListValue : recordColumnUpdatesList) {
                    if (recordColumnUpdatesListValue == null) continue;
                    RecordColumnJsonMarshaller.getInstance().marshall(recordColumnUpdatesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InputSchemaUpdateJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InputSchemaUpdateJsonMarshaller();
        }
        return instance;
    }
}

