/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeWorkspaceDirectoriesRequestMarshaller
implements Marshaller<Request<DescribeWorkspaceDirectoriesRequest>, DescribeWorkspaceDirectoriesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeWorkspaceDirectoriesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeWorkspaceDirectoriesRequest> marshall(DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) {
        if (describeWorkspaceDirectoriesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeWorkspaceDirectoriesRequest> request = new DefaultRequest<DescribeWorkspaceDirectoriesRequest>(describeWorkspaceDirectoriesRequest, "AmazonWorkspaces");
        request.addHeader("X-Amz-Target", "WorkspacesService.DescribeWorkspaceDirectories");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList directoryIdsList = (SdkInternalList)describeWorkspaceDirectoriesRequest.getDirectoryIds();
            if (!directoryIdsList.isEmpty() || !directoryIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DirectoryIds");
                jsonGenerator.writeStartArray();
                for (String directoryIdsListValue : directoryIdsList) {
                    if (directoryIdsListValue == null) continue;
                    jsonGenerator.writeValue(directoryIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeWorkspaceDirectoriesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeWorkspaceDirectoriesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

