/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.ImageAttributeName;
import com.amazonaws.services.ec2.model.transform.DescribeImageAttributeRequestMarshaller;
import java.io.Serializable;

public class DescribeImageAttributeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeImageAttributeRequest> {
    private String imageId;
    private String attribute;

    public DescribeImageAttributeRequest() {
    }

    public DescribeImageAttributeRequest(String imageId, String attribute) {
        this.setImageId(imageId);
        this.setAttribute(attribute);
    }

    public DescribeImageAttributeRequest(String imageId, ImageAttributeName attribute) {
        this.setImageId(imageId);
        this.setAttribute(attribute.toString());
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public DescribeImageAttributeRequest withImageId(String imageId) {
        this.setImageId(imageId);
        return this;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public DescribeImageAttributeRequest withAttribute(String attribute) {
        this.setAttribute(attribute);
        return this;
    }

    public void setAttribute(ImageAttributeName attribute) {
        this.attribute = attribute.toString();
    }

    public DescribeImageAttributeRequest withAttribute(ImageAttributeName attribute) {
        this.setAttribute(attribute);
        return this;
    }

    @Override
    public Request<DescribeImageAttributeRequest> getDryRunRequest() {
        Request<DescribeImageAttributeRequest> request = new DescribeImageAttributeRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImageId() != null) {
            sb.append("ImageId: " + this.getImageId() + ",");
        }
        if (this.getAttribute() != null) {
            sb.append("Attribute: " + this.getAttribute());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageAttributeRequest)) {
            return false;
        }
        DescribeImageAttributeRequest other = (DescribeImageAttributeRequest)obj;
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getAttribute() == null ^ this.getAttribute() == null) {
            return false;
        }
        return other.getAttribute() == null || other.getAttribute().equals(this.getAttribute());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getAttribute() == null ? 0 : this.getAttribute().hashCode());
        return hashCode;
    }

    @Override
    public DescribeImageAttributeRequest clone() {
        return (DescribeImageAttributeRequest)super.clone();
    }
}

