/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchemas;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperModelFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverterFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.S3ClientCache;
import com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardAttributeTypes;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardBeanProperties;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardParameterTypes;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
final class StandardConverterRules {
    private static final Log LOG = LogFactory.getLog(StandardConverterRules.class);

    StandardConverterRules() {
    }

    static final <V> RuleFactory<V> of(DynamoDBMapperConfig config, DynamoDBMapperModelFactory.Factory factory, S3ClientCache s3cc) {
        Rules rules = new Rules(StandardTypeConverters.factory());
        rules.with(String.class, S3Link.class, new S3Link.Factory(s3cc));
        if (config.getConversionSchema() == ConversionSchemas.V1) {
            Rules rules2 = rules;
            rules2.getClass();
            rules.with(rules2.new Rules.NativeBool(true));
            Rules rules3 = rules;
            rules3.getClass();
            rules.with(rules3.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.S));
            Rules rules4 = rules;
            rules4.getClass();
            rules.with(rules4.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.N));
            Rules rules5 = rules;
            rules5.getClass();
            rules.with(rules5.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.B));
            Rules rules6 = rules;
            rules6.getClass();
            rules.with(rules6.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.SS));
            Rules rules7 = rules;
            rules7.getClass();
            rules.with(rules7.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.NS));
            Rules rules8 = rules;
            rules8.getClass();
            rules.with(rules8.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.BS));
            Rules rules9 = rules;
            rules9.getClass();
            rules.with(rules9.new Rules.ObjectToStringSet());
        } else if (config.getConversionSchema() == ConversionSchemas.V2) {
            Rules rules10 = rules;
            rules10.getClass();
            rules.with(rules10.new Rules.NativeBool(false));
            Rules rules11 = rules;
            rules11.getClass();
            rules.with(rules11.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.S));
            Rules rules12 = rules;
            rules12.getClass();
            rules.with(rules12.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.N));
            Rules rules13 = rules;
            rules13.getClass();
            rules.with(rules13.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.B));
            Rules rules14 = rules;
            rules14.getClass();
            rules.with(rules14.new Rules.NativeBoolSet());
            Rules rules15 = rules;
            rules15.getClass();
            rules.with(rules15.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.SS));
            Rules rules16 = rules;
            rules16.getClass();
            rules.with(rules16.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.NS));
            Rules rules17 = rules;
            rules17.getClass();
            rules.with(rules17.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.BS));
            Rules rules18 = rules;
            rules18.getClass();
            rules.with(rules18.new Rules.ObjectSetOrList());
            Rules rules19 = rules;
            rules19.getClass();
            rules.with(rules19.new Rules.ObjectStringKeyMap());
            Rules rules20 = rules;
            rules20.getClass();
            rules.with(rules20.new Rules.ObjectDocumentMap(config, factory));
        } else {
            Rules rules21 = rules;
            rules21.getClass();
            rules.with(rules21.new Rules.NativeBool(true));
            Rules rules22 = rules;
            rules22.getClass();
            rules.with(rules22.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.S));
            Rules rules23 = rules;
            rules23.getClass();
            rules.with(rules23.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.N));
            Rules rules24 = rules;
            rules24.getClass();
            rules.with(rules24.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.B));
            Rules rules25 = rules;
            rules25.getClass();
            rules.with(rules25.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.SS));
            Rules rules26 = rules;
            rules26.getClass();
            rules.with(rules26.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.NS));
            Rules rules27 = rules;
            rules27.getClass();
            rules.with(rules27.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.BS));
            Rules rules28 = rules;
            rules28.getClass();
            rules.with(rules28.new Rules.ObjectToStringSet());
            Rules rules29 = rules;
            rules29.getClass();
            rules.with(rules29.new Rules.ObjectSetOrList());
            Rules rules30 = rules;
            rules30.getClass();
            rules.with(rules30.new Rules.ObjectStringKeyMap());
            Rules rules31 = rules;
            rules31.getClass();
            rules.with(rules31.new Rules.ObjectDocumentMap(config, factory));
        }
        return rules;
    }

    static interface RuleFactory<V> {
        public Rule<V> getRule(StandardBeanProperties.Bean<?, V> var1);
    }

    static interface Rule<V> {
        public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> var1, DynamoDBMapperFieldModel.Properties<?, ?> var2);

        public DynamoDBTypeConverter<AttributeValue, V> newConverter(StandardParameterTypes.ParamType<V> var1);

        public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType();
    }

    private static final class Rules<V>
    extends DynamoDBTypeConverterFactory.OverrideFactory
    implements RuleFactory<V> {
        private final Set<Rule<V>> rules = new LinkedHashSet<Rule<V>>();

        private Rules(DynamoDBTypeConverterFactory converters) {
            super(converters);
        }

        private Rules<V> with(Rule<?> rule) {
            this.rules.add(rule);
            return this;
        }

        private Rule<V> getRule(StandardParameterTypes.ParamType<V> type, DynamoDBMapperFieldModel.Properties<?, V> props) {
            if (props.typeConverter() != null) {
                return new CustomTypeConverted(props);
            }
            for (Rule<V> rule : this.rules) {
                if (!rule.isAssignableFrom(type, props)) continue;
                return rule;
            }
            return new NotSupported();
        }

        @Override
        public Rule<V> getRule(StandardBeanProperties.Bean<?, V> bean) {
            return this.getRule(bean.type(), bean);
        }

        private final class NotSupported
        implements Rule<V> {
            private NotSupported() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                return false;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, V> newConverter(final StandardParameterTypes.ParamType<V> type) {
                return new DynamoDBTypeConverter<AttributeValue, V>(){

                    @Override
                    public final AttributeValue convert(V o) {
                        throw new DynamoDBMappingException("type " + type + " is not supported; requires @DynamoDBDocument or @DynamoDBTypeConverted");
                    }

                    @Override
                    public final V unconvert(AttributeValue o) {
                        throw new DynamoDBMappingException("type " + type + " is not supported; requires @DynamoDBDocument or @DynamoDBTypeConverted");
                    }
                };
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return StandardAttributeTypes.AttributeType.NULL.attributeType();
            }
        }

        private final class ObjectDocumentMap
        implements Rule<V> {
            private final DynamoDBMapperModelFactory.Factory factory;
            private final DynamoDBMapperConfig config;

            private ObjectDocumentMap(DynamoDBMapperConfig config, DynamoDBMapperModelFactory.Factory factory) {
                this.factory = factory;
                this.config = config;
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                if (props.attributeType() == null) {
                    return StandardBeanProperties.of(type.type()).annotations().document() != null;
                }
                return props.attributeType() == this.getAttributeType();
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, V> newConverter(final StandardParameterTypes.ParamType<V> type) {
                return StandardAttributeTypes.AttributeType.M.join(new DynamoDBTypeConverter<Map<String, AttributeValue>, V>(){

                    @Override
                    public final Map<String, AttributeValue> convert(V o) {
                        return ObjectDocumentMap.this.factory.getModelFactory(ObjectDocumentMap.this.config).getTableModel(type.type()).convert(o);
                    }

                    @Override
                    public final V unconvert(Map<String, AttributeValue> o) {
                        return ObjectDocumentMap.this.factory.getModelFactory(ObjectDocumentMap.this.config).getTableModel(type.type()).unconvert(o);
                    }
                });
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return StandardAttributeTypes.AttributeType.M.attributeType();
            }
        }

        private final class ObjectStringKeyMap
        implements Rule<Map<String, V>> {
            private ObjectStringKeyMap() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                if (props.attributeType() == null) {
                    return StandardTypeConverters.Vector.MAP.is(type.type()) && type.param(1) != null && StandardTypeConverters.Scalar.STRING.is(type.param(0).type());
                }
                return false;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Map<String, V>> newConverter(StandardParameterTypes.ParamType<Map<String, V>> type) {
                Rule rule = Rules.this.getRule(type.param(1), DynamoDBMapperFieldModel.Properties.Immutable.empty());
                DynamoDBTypeConverter target = StandardAttributeTypes.AttributeType.NULL.join(rule.newConverter(type.param(1)));
                return StandardAttributeTypes.AttributeType.M.join(StandardTypeConverters.Vector.MAP.join(target));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return StandardAttributeTypes.AttributeType.M.attributeType();
            }
        }

        private final class ObjectSetOrList
        implements Rule<Collection<V>> {
            private ObjectSetOrList() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                if (props.attributeType() == null) {
                    return (StandardTypeConverters.Vector.SET.is(type.type()) || StandardTypeConverters.Vector.LIST.is(type.type())) && type.param(0) != null;
                }
                return false;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Collection<V>> newConverter(StandardParameterTypes.ParamType<Collection<V>> type) {
                Rule rule = Rules.this.getRule(type.param(0), DynamoDBMapperFieldModel.Properties.Immutable.empty());
                DynamoDBTypeConverter target = StandardAttributeTypes.AttributeType.NULL.join(rule.newConverter(type.param(0)));
                return StandardAttributeTypes.AttributeType.L.join(StandardTypeConverters.Vector.SET.is(type.type()) ? StandardTypeConverters.Vector.SET.join(target) : StandardTypeConverters.Vector.LIST.join(target));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return StandardAttributeTypes.AttributeType.L.attributeType();
            }
        }

        private final class NativeBoolSet
        implements Rule<Collection<V>> {
            private NativeBoolSet() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                if (props.attributeType() == null) {
                    return StandardTypeConverters.Vector.SET.is(type.type()) && StandardTypeConverters.Scalar.BOOLEAN.is(type.param(0).type());
                }
                return false;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Collection<V>> newConverter(StandardParameterTypes.ParamType<Collection<V>> type) {
                return DynamoDBTypeConverterFactory.OverrideFactory.join(new DynamoDBTypeConverter<AttributeValue, List<AttributeValue>>(){

                    @Override
                    public final AttributeValue convert(List<AttributeValue> o) {
                        return StandardAttributeTypes.AttributeType.L.convert(o);
                    }

                    @Override
                    public final List<AttributeValue> unconvert(AttributeValue o) {
                        if (o.getL() == null && o.getNS() != null) {
                            return StandardTypeConverters.Vector.LIST.convert(o.getNS(), StandardAttributeTypes.AttributeType.BOOL.join(StandardTypeConverters.Scalar.BOOLEAN.join(String.class)));
                        }
                        return (List)StandardAttributeTypes.AttributeType.L.unconvert(o);
                    }
                }, StandardTypeConverters.Vector.SET.join(StandardAttributeTypes.AttributeType.NULL.join(StandardAttributeTypes.AttributeType.BOOL.join(StandardTypeConverters.Scalar.BOOLEAN.join(type.param(0).type())))));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return StandardAttributeTypes.AttributeType.L.attributeType();
            }
        }

        private final class ObjectToStringSet
        implements Rule<Collection<V>> {
            private ObjectToStringSet() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                if (props.attributeType() == null) {
                    return StandardTypeConverters.Vector.SET.is(type.type());
                }
                return false;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Collection<V>> newConverter(StandardParameterTypes.ParamType<Collection<V>> type) {
                LOG.warn((Object)"Marshaling a set of non-String objects to a DynamoDB StringSet. You won't be able to read these objects back out of DynamoDB unless you REALLY know what you're doing: it's probably a bug. If you DO know what you're doing feel to ignore this warning, but consider using a custom @DynamoDBTypeConverted/DynamoDBTypeConverter for this instead.");
                return StandardAttributeTypes.AttributeType.SS.join(StandardTypeConverters.Vector.SET.join(StandardTypeConverters.Scalar.STRING.join(StandardTypeConverters.Scalar.DEFAULT.type())));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return StandardAttributeTypes.AttributeType.SS.attributeType();
            }
        }

        private final class SimpleScalarSet
        implements Rule<Collection<V>> {
            private final StandardAttributeTypes.AttributeType attribute;
            private final Class<V> sourceType;

            private SimpleScalarSet(StandardAttributeTypes.AttributeType attribute) {
                this.sourceType = (attribute == StandardAttributeTypes.AttributeType.BS ? StandardTypeConverters.Scalar.BYTE_BUFFER : StandardTypeConverters.Scalar.STRING).type();
                this.attribute = attribute;
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                if (props.attributeType() == null) {
                    return StandardTypeConverters.Vector.SET.is(type.type()) && type.param(0).scalar().is(this.attribute.scalarAttributeType());
                }
                return props.attributeType() == this.getAttributeType();
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Collection<V>> newConverter(StandardParameterTypes.ParamType<Collection<V>> type) {
                DynamoDBTypeConverter target = Rules.this.getConverter(this.sourceType, type.param(0).type());
                return this.attribute.join(StandardTypeConverters.Vector.SET.join(target));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return this.attribute.attributeType();
            }
        }

        private final class SimpleScalar
        implements Rule<V> {
            private final StandardAttributeTypes.AttributeType attribute;
            private final Class<V> sourceType;

            private SimpleScalar(StandardAttributeTypes.AttributeType attribute) {
                this.sourceType = (attribute == StandardAttributeTypes.AttributeType.B ? StandardTypeConverters.Scalar.BYTE_BUFFER : StandardTypeConverters.Scalar.STRING).type();
                this.attribute = attribute;
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                if (props.attributeType() == null) {
                    return !StandardTypeConverters.Vector.SET.is(type.type()) && type.scalar().is(this.attribute.scalarAttributeType());
                }
                return props.attributeType() == this.getAttributeType();
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, V> newConverter(StandardParameterTypes.ParamType<V> type) {
                DynamoDBTypeConverter target = Rules.this.getConverter(this.sourceType, type.type());
                return this.attribute.join(target);
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return this.attribute.attributeType();
            }
        }

        private final class NativeBool
        implements Rule<V> {
            private final boolean onlyIfOverride;

            private NativeBool(boolean onlyIfOverride) {
                this.onlyIfOverride = onlyIfOverride;
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                if (props.attributeType() == null) {
                    return !this.onlyIfOverride && !StandardTypeConverters.Vector.SET.is(type.type()) && StandardTypeConverters.Scalar.BOOLEAN.is(type.type());
                }
                return props.attributeType() == this.getAttributeType();
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, V> newConverter(StandardParameterTypes.ParamType<V> type) {
                return StandardAttributeTypes.AttributeType.BOOL.join(StandardTypeConverters.Scalar.BOOLEAN.join(type.type()));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return StandardAttributeTypes.AttributeType.BOOL.attributeType();
            }
        }

        private final class CustomTypeConverted
        implements Rule<V> {
            private final DynamoDBTypeConverter<V, V> target;
            private final StandardParameterTypes.ParamType<V> sourceType;
            private final Rule<V> rule;

            private CustomTypeConverted(DynamoDBMapperFieldModel.Properties<?, V> props) {
                this.target = props.typeConverter();
                this.sourceType = StandardParameterTypes.of(this.target);
                this.rule = Rules.this.getRule(this.sourceType, new DynamoDBMapperFieldModel.Properties.Buildable(props).withTypeConverter(null));
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                return true;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, V> newConverter(StandardParameterTypes.ParamType<V> type) {
                DynamoDBTypeConverter source = this.rule.newConverter(this.sourceType);
                return DynamoDBTypeConverterFactory.OverrideFactory.join(source, this.target);
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return this.rule.getAttributeType();
            }
        }
    }
}

