/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.PutConfigurationRecorderRequest;
import com.amazonaws.services.config.model.transform.ConfigurationRecorderJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class PutConfigurationRecorderRequestMarshaller
implements Marshaller<Request<PutConfigurationRecorderRequest>, PutConfigurationRecorderRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PutConfigurationRecorderRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<PutConfigurationRecorderRequest> marshall(PutConfigurationRecorderRequest putConfigurationRecorderRequest) {
        if (putConfigurationRecorderRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutConfigurationRecorderRequest> request = new DefaultRequest<PutConfigurationRecorderRequest>(putConfigurationRecorderRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.PutConfigurationRecorder");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putConfigurationRecorderRequest.getConfigurationRecorder() != null) {
                jsonGenerator.writeFieldName("ConfigurationRecorder");
                ConfigurationRecorderJsonMarshaller.getInstance().marshall(putConfigurationRecorderRequest.getConfigurationRecorder(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

