/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;

public interface DynamoDBTypeConverterFactory {
    public <S, T> DynamoDBTypeConverter<S, T> getConverter(Class<S> var1, Class<T> var2);

    @NotThreadSafe
    public static class OverrideFactory
    implements DynamoDBTypeConverterFactory {
        private final Map<Key<?, ?>, DynamoDBTypeConverter<?, ?>> overrides = new LinkedHashMap();
        private final DynamoDBTypeConverterFactory delegate;

        public OverrideFactory(DynamoDBTypeConverterFactory delegate) {
            this.delegate = delegate;
        }

        public <S, T> OverrideFactory with(Class<S> sourceType, Class<T> targetType, DynamoDBTypeConverter<S, T> converter) {
            this.overrides.put(new Key<S, T>(sourceType, targetType), converter);
            return this;
        }

        @Override
        public <S, T> DynamoDBTypeConverter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
            for (Map.Entry<Key<?, ?>, DynamoDBTypeConverter<?, ?>> entry : this.overrides.entrySet()) {
                if (!entry.getKey().isAssignableFrom(sourceType, targetType)) continue;
                return entry.getValue();
            }
            return this.delegate.getConverter(sourceType, targetType);
        }

        public static final <S, T, U> DynamoDBTypeConverter<S, U> join(final DynamoDBTypeConverter<S, T> source, final DynamoDBTypeConverter<T, U> target) {
            return new DynamoDBTypeConverter<S, U>(){

                @Override
                public final S convert(U o) {
                    Object object = o == null ? null : (Object)target.convert(o);
                    return object == null ? null : (Object)source.convert(object);
                }

                @Override
                public final U unconvert(S o) {
                    Object object = o == null ? null : (Object)source.unconvert(o);
                    return object == null ? null : (Object)target.unconvert(object);
                }
            };
        }

        public static final class Key<S, T>
        extends AbstractMap.SimpleImmutableEntry<Class<S>, Class<T>> {
            public Key(Class<S> sourceType, Class<T> targetType) {
                super(sourceType, targetType);
            }

            public boolean isAssignableFrom(Class<?> sourceType, Class<?> targetType) {
                return ((Class)this.getKey()).isAssignableFrom(sourceType) && ((Class)this.getValue()).isAssignableFrom(targetType);
            }
        }
    }
}

