/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerator;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@DynamoDB
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.ANNOTATION_TYPE})
public @interface DynamoDBAutoGenerated {
    public Class<? extends DynamoDBAutoGenerator> generator();

    public static final class Generators {
        static <T> DynamoDBAutoGenerator<T> of(Class<T> targetType, Annotation annotation) {
            DynamoDBAutoGenerated generated;
            if (annotation.annotationType() == DynamoDBAutoGenerated.class) {
                generated = (DynamoDBAutoGenerated)annotation;
            } else {
                generated = annotation.annotationType().getAnnotation(DynamoDBAutoGenerated.class);
                if (generated == null) {
                    throw new DynamoDBMappingException("could not resolve auto-generator: " + annotation);
                }
            }
            DynamoDBAutoGenerator generator = null;
            try {
                if (annotation != generated) {
                    try {
                        generator = generated.generator().getConstructor(Class.class, annotation.annotationType()).newInstance(targetType, annotation);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (generator == null) {
                    try {
                        generator = generated.generator().getConstructor(Class.class).newInstance(targetType);
                    }
                    catch (NoSuchMethodException no) {
                        generator = generated.generator().newInstance();
                    }
                }
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("could not create auto-generator: " + annotation, e);
            }
            if (generator.getGenerateStrategy() == DynamoDBAutoGenerateStrategy.CREATE && targetType.isPrimitive()) {
                throw new DynamoDBMappingException("type [" + targetType + "] is not supported; primitives are not allowed when auto-generate strategy is CREATE");
            }
            return generator;
        }
    }
}

