/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.InputStream;
import java.io.Serializable;

public class UploadArchiveRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String vaultName;
    private String accountId;
    private String archiveDescription;
    private String checksum;
    private InputStream body;
    private Long contentLength;

    public UploadArchiveRequest() {
    }

    public UploadArchiveRequest(String vaultName, String archiveDescription, String checksum, InputStream body) {
        this.setVaultName(vaultName);
        this.setArchiveDescription(archiveDescription);
        this.setChecksum(checksum);
        this.setBody(body);
    }

    public UploadArchiveRequest(String vaultName, String accountId, String archiveDescription, String checksum, InputStream body) {
        this.setVaultName(vaultName);
        this.setAccountId(accountId);
        this.setArchiveDescription(archiveDescription);
        this.setChecksum(checksum);
        this.setBody(body);
    }

    public void setVaultName(String vaultName) {
        this.vaultName = vaultName;
    }

    public String getVaultName() {
        return this.vaultName;
    }

    public UploadArchiveRequest withVaultName(String vaultName) {
        this.setVaultName(vaultName);
        return this;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public UploadArchiveRequest withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setArchiveDescription(String archiveDescription) {
        this.archiveDescription = archiveDescription;
    }

    public String getArchiveDescription() {
        return this.archiveDescription;
    }

    public UploadArchiveRequest withArchiveDescription(String archiveDescription) {
        this.setArchiveDescription(archiveDescription);
        return this;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public UploadArchiveRequest withChecksum(String checksum) {
        this.setChecksum(checksum);
        return this;
    }

    public void setBody(InputStream body) {
        this.body = body;
    }

    public InputStream getBody() {
        return this.body;
    }

    public UploadArchiveRequest withBody(InputStream body) {
        this.setBody(body);
        return this;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public UploadArchiveRequest withContentLength(Long contentLength) {
        this.setContentLength(contentLength);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVaultName() != null) {
            sb.append("VaultName: " + this.getVaultName() + ",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: " + this.getAccountId() + ",");
        }
        if (this.getArchiveDescription() != null) {
            sb.append("ArchiveDescription: " + this.getArchiveDescription() + ",");
        }
        if (this.getChecksum() != null) {
            sb.append("Checksum: " + this.getChecksum() + ",");
        }
        if (this.getBody() != null) {
            sb.append("Body: " + this.getBody() + ",");
        }
        if (this.getContentLength() != null) {
            sb.append("ContentLength: " + this.getContentLength());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadArchiveRequest)) {
            return false;
        }
        UploadArchiveRequest other = (UploadArchiveRequest)obj;
        if (other.getVaultName() == null ^ this.getVaultName() == null) {
            return false;
        }
        if (other.getVaultName() != null && !other.getVaultName().equals(this.getVaultName())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getArchiveDescription() == null ^ this.getArchiveDescription() == null) {
            return false;
        }
        if (other.getArchiveDescription() != null && !other.getArchiveDescription().equals(this.getArchiveDescription())) {
            return false;
        }
        if (other.getChecksum() == null ^ this.getChecksum() == null) {
            return false;
        }
        if (other.getChecksum() != null && !other.getChecksum().equals(this.getChecksum())) {
            return false;
        }
        if (other.getBody() == null ^ this.getBody() == null) {
            return false;
        }
        if (other.getBody() != null && !other.getBody().equals(this.getBody())) {
            return false;
        }
        if (other.getContentLength() == null ^ this.getContentLength() == null) {
            return false;
        }
        return other.getContentLength() == null || other.getContentLength().equals(this.getContentLength());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVaultName() == null ? 0 : this.getVaultName().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getArchiveDescription() == null ? 0 : this.getArchiveDescription().hashCode());
        hashCode = 31 * hashCode + (this.getChecksum() == null ? 0 : this.getChecksum().hashCode());
        hashCode = 31 * hashCode + (this.getBody() == null ? 0 : this.getBody().hashCode());
        hashCode = 31 * hashCode + (this.getContentLength() == null ? 0 : this.getContentLength().hashCode());
        return hashCode;
    }

    @Override
    public UploadArchiveRequest clone() {
        return (UploadArchiveRequest)super.clone();
    }
}

