/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.AmazonSimpleDBClientBuilder;
import com.amazonaws.services.simpledb.SimpleDBResponseMetadata;
import com.amazonaws.services.simpledb.internal.SimpleDBStaxResponseHandler;
import com.amazonaws.services.simpledb.model.AmazonSimpleDBException;
import com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.BatchDeleteAttributesResult;
import com.amazonaws.services.simpledb.model.BatchPutAttributesRequest;
import com.amazonaws.services.simpledb.model.BatchPutAttributesResult;
import com.amazonaws.services.simpledb.model.CreateDomainRequest;
import com.amazonaws.services.simpledb.model.CreateDomainResult;
import com.amazonaws.services.simpledb.model.DeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.DeleteAttributesResult;
import com.amazonaws.services.simpledb.model.DeleteDomainRequest;
import com.amazonaws.services.simpledb.model.DeleteDomainResult;
import com.amazonaws.services.simpledb.model.DomainMetadataRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataResult;
import com.amazonaws.services.simpledb.model.GetAttributesRequest;
import com.amazonaws.services.simpledb.model.GetAttributesResult;
import com.amazonaws.services.simpledb.model.ListDomainsRequest;
import com.amazonaws.services.simpledb.model.ListDomainsResult;
import com.amazonaws.services.simpledb.model.PutAttributesRequest;
import com.amazonaws.services.simpledb.model.PutAttributesResult;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import com.amazonaws.services.simpledb.model.transform.AttributeDoesNotExistExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.BatchDeleteAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.BatchDeleteAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.BatchPutAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.BatchPutAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.CreateDomainRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.CreateDomainResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.DeleteAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.DeleteAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.DeleteDomainRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.DeleteDomainResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.DomainMetadataRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.DomainMetadataResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.DuplicateItemNameExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.GetAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.GetAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidNumberPredicatesExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidNumberValueTestsExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidQueryExpressionExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.ListDomainsRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.ListDomainsResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.MissingParameterExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NoSuchDomainExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberDomainAttributesExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberDomainBytesExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberDomainsExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberItemAttributesExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberSubmittedAttributesExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberSubmittedItemsExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.PutAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.PutAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.RequestTimeoutExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.SelectRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.SelectResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.TooManyRequestedAttributesExceptionUnmarshaller;
import com.amazonaws.transform.LegacyErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

@ThreadSafe
public class AmazonSimpleDBClient
extends AmazonWebServiceClient
implements AmazonSimpleDB {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonSimpleDB.class);
    private static final String DEFAULT_SIGNING_NAME = "sdb";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    @Deprecated
    public AmazonSimpleDBClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonSimpleDBClient(ClientConfiguration clientConfiguration) {
        this(DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonSimpleDBClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonSimpleDBClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AmazonSimpleDBClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonSimpleDBClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonSimpleDBClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AmazonSimpleDBClientBuilder builder() {
        return AmazonSimpleDBClientBuilder.standard();
    }

    AmazonSimpleDBClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new NumberItemAttributesExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NumberSubmittedItemsExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidNumberPredicatesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NumberDomainBytesExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AttributeDoesNotExistExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NumberDomainsExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchDomainExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new RequestTimeoutExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidParameterValueExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DuplicateItemNameExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyRequestedAttributesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NumberSubmittedAttributesExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidQueryExpressionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NumberDomainAttributesExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidNumberValueTestsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidNextTokenExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MissingParameterExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LegacyErrorUnmarshaller(AmazonSimpleDBException.class));
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("sdb.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/simpledb/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/simpledb/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchDeleteAttributesResult batchDeleteAttributes(BatchDeleteAttributesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeBatchDeleteAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchDeleteAttributesResult executeBatchDeleteAttributes(BatchDeleteAttributesRequest batchDeleteAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDeleteAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDeleteAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDeleteAttributesRequestMarshaller().marshall(super.beforeMarshalling(batchDeleteAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<BatchDeleteAttributesResult> responseHandler = new SimpleDBStaxResponseHandler<BatchDeleteAttributesResult>(new BatchDeleteAttributesResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchDeleteAttributesResult batchDeleteAttributesResult = (BatchDeleteAttributesResult)response.getAwsResponse();
            return batchDeleteAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchPutAttributesResult batchPutAttributes(BatchPutAttributesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeBatchPutAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchPutAttributesResult executeBatchPutAttributes(BatchPutAttributesRequest batchPutAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchPutAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchPutAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchPutAttributesRequestMarshaller().marshall(super.beforeMarshalling(batchPutAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<BatchPutAttributesResult> responseHandler = new SimpleDBStaxResponseHandler<BatchPutAttributesResult>(new BatchPutAttributesResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchPutAttributesResult batchPutAttributesResult = (BatchPutAttributesResult)response.getAwsResponse();
            return batchPutAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDomainResult createDomain(CreateDomainRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDomainResult executeCreateDomain(CreateDomainRequest createDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDomainRequestMarshaller().marshall(super.beforeMarshalling(createDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<CreateDomainResult> responseHandler = new SimpleDBStaxResponseHandler<CreateDomainResult>(new CreateDomainResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDomainResult createDomainResult = (CreateDomainResult)response.getAwsResponse();
            return createDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAttributesResult deleteAttributes(DeleteAttributesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAttributesResult executeDeleteAttributes(DeleteAttributesRequest deleteAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAttributesRequestMarshaller().marshall(super.beforeMarshalling(deleteAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<DeleteAttributesResult> responseHandler = new SimpleDBStaxResponseHandler<DeleteAttributesResult>(new DeleteAttributesResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAttributesResult deleteAttributesResult = (DeleteAttributesResult)response.getAwsResponse();
            return deleteAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDomainResult deleteDomain(DeleteDomainRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDomainResult executeDeleteDomain(DeleteDomainRequest deleteDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDomainRequestMarshaller().marshall(super.beforeMarshalling(deleteDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<DeleteDomainResult> responseHandler = new SimpleDBStaxResponseHandler<DeleteDomainResult>(new DeleteDomainResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDomainResult deleteDomainResult = (DeleteDomainResult)response.getAwsResponse();
            return deleteDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DomainMetadataResult domainMetadata(DomainMetadataRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDomainMetadata(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DomainMetadataResult executeDomainMetadata(DomainMetadataRequest domainMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(domainMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DomainMetadataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DomainMetadataRequestMarshaller().marshall(super.beforeMarshalling(domainMetadataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<DomainMetadataResult> responseHandler = new SimpleDBStaxResponseHandler<DomainMetadataResult>(new DomainMetadataResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DomainMetadataResult domainMetadataResult = (DomainMetadataResult)response.getAwsResponse();
            return domainMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAttributesResult getAttributes(GetAttributesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAttributesResult executeGetAttributes(GetAttributesRequest getAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAttributesRequestMarshaller().marshall(super.beforeMarshalling(getAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<GetAttributesResult> responseHandler = new SimpleDBStaxResponseHandler<GetAttributesResult>(new GetAttributesResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAttributesResult getAttributesResult = (GetAttributesResult)response.getAwsResponse();
            return getAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDomainsResult listDomains(ListDomainsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListDomains(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDomainsResult executeListDomains(ListDomainsRequest listDomainsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDomainsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDomainsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDomainsRequestMarshaller().marshall(super.beforeMarshalling(listDomainsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<ListDomainsResult> responseHandler = new SimpleDBStaxResponseHandler<ListDomainsResult>(new ListDomainsResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDomainsResult listDomainsResult = (ListDomainsResult)response.getAwsResponse();
            return listDomainsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDomainsResult listDomains() {
        return this.listDomains(new ListDomainsRequest());
    }

    @Override
    public PutAttributesResult putAttributes(PutAttributesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutAttributesResult executePutAttributes(PutAttributesRequest putAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutAttributesRequestMarshaller().marshall(super.beforeMarshalling(putAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<PutAttributesResult> responseHandler = new SimpleDBStaxResponseHandler<PutAttributesResult>(new PutAttributesResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutAttributesResult putAttributesResult = (PutAttributesResult)response.getAwsResponse();
            return putAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SelectResult select(SelectRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeSelect(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SelectResult executeSelect(SelectRequest selectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(selectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SelectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SelectRequestMarshaller().marshall(super.beforeMarshalling(selectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<SelectResult> responseHandler = new SimpleDBStaxResponseHandler<SelectResult>(new SelectResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SelectResult selectResult = (SelectResult)response.getAwsResponse();
            return selectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    public SimpleDBResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        ResponseMetadata metadata = this.client.getResponseMetadataForRequest(request);
        if (metadata != null) {
            return new SimpleDBResponseMetadata(metadata);
        }
        return null;
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

