/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mq.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mq.model.WeeklyStartTime;

@SdkInternalApi
public class WeeklyStartTimeMarshaller {
    private static final MarshallingInfo<String> DAYOFWEEK_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dayOfWeek").build();
    private static final MarshallingInfo<String> TIMEOFDAY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeOfDay").build();
    private static final MarshallingInfo<String> TIMEZONE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeZone").build();
    private static final WeeklyStartTimeMarshaller instance = new WeeklyStartTimeMarshaller();

    public static WeeklyStartTimeMarshaller getInstance() {
        return instance;
    }

    public void marshall(WeeklyStartTime weeklyStartTime, ProtocolMarshaller protocolMarshaller) {
        if (weeklyStartTime == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(weeklyStartTime.getDayOfWeek(), DAYOFWEEK_BINDING);
            protocolMarshaller.marshall(weeklyStartTime.getTimeOfDay(), TIMEOFDAY_BINDING);
            protocolMarshaller.marshall(weeklyStartTime.getTimeZone(), TIMEZONE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

