/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscalingplans.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.autoscalingplans.model.ApplicationSource;
import com.amazonaws.services.autoscalingplans.model.ScalingInstruction;
import com.amazonaws.services.autoscalingplans.model.ScalingPlanStatusCode;
import com.amazonaws.services.autoscalingplans.model.transform.ScalingPlanMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ScalingPlan
implements Serializable,
Cloneable,
StructuredPojo {
    private String scalingPlanName;
    private Long scalingPlanVersion;
    private ApplicationSource applicationSource;
    private List<ScalingInstruction> scalingInstructions;
    private String statusCode;
    private String statusMessage;
    private Date creationTime;

    public void setScalingPlanName(String scalingPlanName) {
        this.scalingPlanName = scalingPlanName;
    }

    public String getScalingPlanName() {
        return this.scalingPlanName;
    }

    public ScalingPlan withScalingPlanName(String scalingPlanName) {
        this.setScalingPlanName(scalingPlanName);
        return this;
    }

    public void setScalingPlanVersion(Long scalingPlanVersion) {
        this.scalingPlanVersion = scalingPlanVersion;
    }

    public Long getScalingPlanVersion() {
        return this.scalingPlanVersion;
    }

    public ScalingPlan withScalingPlanVersion(Long scalingPlanVersion) {
        this.setScalingPlanVersion(scalingPlanVersion);
        return this;
    }

    public void setApplicationSource(ApplicationSource applicationSource) {
        this.applicationSource = applicationSource;
    }

    public ApplicationSource getApplicationSource() {
        return this.applicationSource;
    }

    public ScalingPlan withApplicationSource(ApplicationSource applicationSource) {
        this.setApplicationSource(applicationSource);
        return this;
    }

    public List<ScalingInstruction> getScalingInstructions() {
        return this.scalingInstructions;
    }

    public void setScalingInstructions(Collection<ScalingInstruction> scalingInstructions) {
        if (scalingInstructions == null) {
            this.scalingInstructions = null;
            return;
        }
        this.scalingInstructions = new ArrayList<ScalingInstruction>(scalingInstructions);
    }

    public ScalingPlan withScalingInstructions(ScalingInstruction ... scalingInstructions) {
        if (this.scalingInstructions == null) {
            this.setScalingInstructions(new ArrayList<ScalingInstruction>(scalingInstructions.length));
        }
        for (ScalingInstruction ele : scalingInstructions) {
            this.scalingInstructions.add(ele);
        }
        return this;
    }

    public ScalingPlan withScalingInstructions(Collection<ScalingInstruction> scalingInstructions) {
        this.setScalingInstructions(scalingInstructions);
        return this;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public ScalingPlan withStatusCode(String statusCode) {
        this.setStatusCode(statusCode);
        return this;
    }

    public ScalingPlan withStatusCode(ScalingPlanStatusCode statusCode) {
        this.statusCode = statusCode.toString();
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public ScalingPlan withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public ScalingPlan withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getScalingPlanName() != null) {
            sb.append("ScalingPlanName: ").append(this.getScalingPlanName()).append(",");
        }
        if (this.getScalingPlanVersion() != null) {
            sb.append("ScalingPlanVersion: ").append(this.getScalingPlanVersion()).append(",");
        }
        if (this.getApplicationSource() != null) {
            sb.append("ApplicationSource: ").append(this.getApplicationSource()).append(",");
        }
        if (this.getScalingInstructions() != null) {
            sb.append("ScalingInstructions: ").append(this.getScalingInstructions()).append(",");
        }
        if (this.getStatusCode() != null) {
            sb.append("StatusCode: ").append(this.getStatusCode()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPlan)) {
            return false;
        }
        ScalingPlan other = (ScalingPlan)obj;
        if (other.getScalingPlanName() == null ^ this.getScalingPlanName() == null) {
            return false;
        }
        if (other.getScalingPlanName() != null && !other.getScalingPlanName().equals(this.getScalingPlanName())) {
            return false;
        }
        if (other.getScalingPlanVersion() == null ^ this.getScalingPlanVersion() == null) {
            return false;
        }
        if (other.getScalingPlanVersion() != null && !other.getScalingPlanVersion().equals(this.getScalingPlanVersion())) {
            return false;
        }
        if (other.getApplicationSource() == null ^ this.getApplicationSource() == null) {
            return false;
        }
        if (other.getApplicationSource() != null && !other.getApplicationSource().equals(this.getApplicationSource())) {
            return false;
        }
        if (other.getScalingInstructions() == null ^ this.getScalingInstructions() == null) {
            return false;
        }
        if (other.getScalingInstructions() != null && !other.getScalingInstructions().equals(this.getScalingInstructions())) {
            return false;
        }
        if (other.getStatusCode() == null ^ this.getStatusCode() == null) {
            return false;
        }
        if (other.getStatusCode() != null && !other.getStatusCode().equals(this.getStatusCode())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        if (other.getStatusMessage() != null && !other.getStatusMessage().equals(this.getStatusMessage())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        return other.getCreationTime() == null || other.getCreationTime().equals(this.getCreationTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getScalingPlanName() == null ? 0 : this.getScalingPlanName().hashCode());
        hashCode = 31 * hashCode + (this.getScalingPlanVersion() == null ? 0 : this.getScalingPlanVersion().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationSource() == null ? 0 : this.getApplicationSource().hashCode());
        hashCode = 31 * hashCode + (this.getScalingInstructions() == null ? 0 : this.getScalingInstructions().hashCode());
        hashCode = 31 * hashCode + (this.getStatusCode() == null ? 0 : this.getStatusCode().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        return hashCode;
    }

    public ScalingPlan clone() {
        try {
            return (ScalingPlan)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScalingPlanMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

