/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appsync;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.appsync.AWSAppSync;
import com.amazonaws.services.appsync.AWSAppSyncClientBuilder;
import com.amazonaws.services.appsync.model.AWSAppSyncException;
import com.amazonaws.services.appsync.model.ApiKeyLimitExceededException;
import com.amazonaws.services.appsync.model.ApiLimitExceededException;
import com.amazonaws.services.appsync.model.BadRequestException;
import com.amazonaws.services.appsync.model.ConcurrentModificationException;
import com.amazonaws.services.appsync.model.CreateApiKeyRequest;
import com.amazonaws.services.appsync.model.CreateApiKeyResult;
import com.amazonaws.services.appsync.model.CreateDataSourceRequest;
import com.amazonaws.services.appsync.model.CreateDataSourceResult;
import com.amazonaws.services.appsync.model.CreateGraphqlApiRequest;
import com.amazonaws.services.appsync.model.CreateGraphqlApiResult;
import com.amazonaws.services.appsync.model.CreateResolverRequest;
import com.amazonaws.services.appsync.model.CreateResolverResult;
import com.amazonaws.services.appsync.model.CreateTypeRequest;
import com.amazonaws.services.appsync.model.CreateTypeResult;
import com.amazonaws.services.appsync.model.DeleteApiKeyRequest;
import com.amazonaws.services.appsync.model.DeleteApiKeyResult;
import com.amazonaws.services.appsync.model.DeleteDataSourceRequest;
import com.amazonaws.services.appsync.model.DeleteDataSourceResult;
import com.amazonaws.services.appsync.model.DeleteGraphqlApiRequest;
import com.amazonaws.services.appsync.model.DeleteGraphqlApiResult;
import com.amazonaws.services.appsync.model.DeleteResolverRequest;
import com.amazonaws.services.appsync.model.DeleteResolverResult;
import com.amazonaws.services.appsync.model.DeleteTypeRequest;
import com.amazonaws.services.appsync.model.DeleteTypeResult;
import com.amazonaws.services.appsync.model.GetDataSourceRequest;
import com.amazonaws.services.appsync.model.GetDataSourceResult;
import com.amazonaws.services.appsync.model.GetGraphqlApiRequest;
import com.amazonaws.services.appsync.model.GetGraphqlApiResult;
import com.amazonaws.services.appsync.model.GetIntrospectionSchemaRequest;
import com.amazonaws.services.appsync.model.GetIntrospectionSchemaResult;
import com.amazonaws.services.appsync.model.GetResolverRequest;
import com.amazonaws.services.appsync.model.GetResolverResult;
import com.amazonaws.services.appsync.model.GetSchemaCreationStatusRequest;
import com.amazonaws.services.appsync.model.GetSchemaCreationStatusResult;
import com.amazonaws.services.appsync.model.GetTypeRequest;
import com.amazonaws.services.appsync.model.GetTypeResult;
import com.amazonaws.services.appsync.model.GraphQLSchemaException;
import com.amazonaws.services.appsync.model.InternalFailureException;
import com.amazonaws.services.appsync.model.LimitExceededException;
import com.amazonaws.services.appsync.model.ListApiKeysRequest;
import com.amazonaws.services.appsync.model.ListApiKeysResult;
import com.amazonaws.services.appsync.model.ListDataSourcesRequest;
import com.amazonaws.services.appsync.model.ListDataSourcesResult;
import com.amazonaws.services.appsync.model.ListGraphqlApisRequest;
import com.amazonaws.services.appsync.model.ListGraphqlApisResult;
import com.amazonaws.services.appsync.model.ListResolversRequest;
import com.amazonaws.services.appsync.model.ListResolversResult;
import com.amazonaws.services.appsync.model.ListTypesRequest;
import com.amazonaws.services.appsync.model.ListTypesResult;
import com.amazonaws.services.appsync.model.NotFoundException;
import com.amazonaws.services.appsync.model.StartSchemaCreationRequest;
import com.amazonaws.services.appsync.model.StartSchemaCreationResult;
import com.amazonaws.services.appsync.model.UnauthorizedException;
import com.amazonaws.services.appsync.model.UpdateDataSourceRequest;
import com.amazonaws.services.appsync.model.UpdateDataSourceResult;
import com.amazonaws.services.appsync.model.UpdateGraphqlApiRequest;
import com.amazonaws.services.appsync.model.UpdateGraphqlApiResult;
import com.amazonaws.services.appsync.model.UpdateResolverRequest;
import com.amazonaws.services.appsync.model.UpdateResolverResult;
import com.amazonaws.services.appsync.model.UpdateTypeRequest;
import com.amazonaws.services.appsync.model.UpdateTypeResult;
import com.amazonaws.services.appsync.model.transform.CreateApiKeyRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.CreateApiKeyResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.CreateDataSourceRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.CreateDataSourceResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.CreateGraphqlApiRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.CreateGraphqlApiResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.CreateResolverRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.CreateResolverResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.CreateTypeRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.CreateTypeResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.DeleteApiKeyRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.DeleteApiKeyResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.DeleteDataSourceRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.DeleteDataSourceResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.DeleteGraphqlApiRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.DeleteGraphqlApiResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.DeleteResolverRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.DeleteResolverResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.DeleteTypeRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.DeleteTypeResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.GetDataSourceRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.GetDataSourceResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.GetGraphqlApiRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.GetGraphqlApiResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.GetIntrospectionSchemaRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.GetIntrospectionSchemaResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.GetResolverRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.GetResolverResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.GetSchemaCreationStatusRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.GetSchemaCreationStatusResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.GetTypeRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.GetTypeResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.ListApiKeysRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.ListApiKeysResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.ListDataSourcesRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.ListDataSourcesResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.ListGraphqlApisRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.ListGraphqlApisResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.ListResolversRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.ListResolversResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.ListTypesRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.ListTypesResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.StartSchemaCreationRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.StartSchemaCreationResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.UpdateDataSourceRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.UpdateDataSourceResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.UpdateGraphqlApiRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.UpdateGraphqlApiResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.UpdateResolverRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.UpdateResolverResultJsonUnmarshaller;
import com.amazonaws.services.appsync.model.transform.UpdateTypeRequestProtocolMarshaller;
import com.amazonaws.services.appsync.model.transform.UpdateTypeResultJsonUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSAppSyncClient
extends AmazonWebServiceClient
implements AWSAppSync {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSAppSync.class);
    private static final String DEFAULT_SIGNING_NAME = "appsync";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withModeledClass(ConcurrentModificationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalFailureException").withModeledClass(InternalFailureException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("GraphQLSchemaException").withModeledClass(GraphQLSchemaException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ApiLimitExceededException").withModeledClass(ApiLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedException").withModeledClass(UnauthorizedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ApiKeyLimitExceededException").withModeledClass(ApiKeyLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).withBaseServiceExceptionClass(AWSAppSyncException.class));

    public static AWSAppSyncClientBuilder builder() {
        return AWSAppSyncClientBuilder.standard();
    }

    AWSAppSyncClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("appsync.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/appsync/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/appsync/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateApiKeyResult createApiKey(CreateApiKeyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateApiKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateApiKeyResult executeCreateApiKey(CreateApiKeyRequest createApiKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createApiKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateApiKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateApiKeyRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createApiKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateApiKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateApiKeyResult createApiKeyResult = (CreateApiKeyResult)response.getAwsResponse();
            return createApiKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDataSourceResult createDataSource(CreateDataSourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateDataSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDataSourceResult executeCreateDataSource(CreateDataSourceRequest createDataSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDataSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDataSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDataSourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createDataSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateDataSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDataSourceResult createDataSourceResult = (CreateDataSourceResult)response.getAwsResponse();
            return createDataSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateGraphqlApiResult createGraphqlApi(CreateGraphqlApiRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateGraphqlApi(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateGraphqlApiResult executeCreateGraphqlApi(CreateGraphqlApiRequest createGraphqlApiRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createGraphqlApiRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateGraphqlApiRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateGraphqlApiRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createGraphqlApiRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateGraphqlApiResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateGraphqlApiResult createGraphqlApiResult = (CreateGraphqlApiResult)response.getAwsResponse();
            return createGraphqlApiResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateResolverResult createResolver(CreateResolverRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateResolver(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateResolverResult executeCreateResolver(CreateResolverRequest createResolverRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createResolverRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateResolverRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateResolverRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createResolverRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateResolverResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateResolverResult createResolverResult = (CreateResolverResult)response.getAwsResponse();
            return createResolverResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateTypeResult createType(CreateTypeRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateTypeResult executeCreateType(CreateTypeRequest createTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTypeRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateTypeResult createTypeResult = (CreateTypeResult)response.getAwsResponse();
            return createTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteApiKeyResult deleteApiKey(DeleteApiKeyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteApiKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteApiKeyResult executeDeleteApiKey(DeleteApiKeyRequest deleteApiKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteApiKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteApiKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteApiKeyRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteApiKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteApiKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteApiKeyResult deleteApiKeyResult = (DeleteApiKeyResult)response.getAwsResponse();
            return deleteApiKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDataSourceResult deleteDataSource(DeleteDataSourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteDataSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDataSourceResult executeDeleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDataSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDataSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDataSourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteDataSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteDataSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDataSourceResult deleteDataSourceResult = (DeleteDataSourceResult)response.getAwsResponse();
            return deleteDataSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteGraphqlApiResult deleteGraphqlApi(DeleteGraphqlApiRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteGraphqlApi(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteGraphqlApiResult executeDeleteGraphqlApi(DeleteGraphqlApiRequest deleteGraphqlApiRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteGraphqlApiRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteGraphqlApiRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteGraphqlApiRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteGraphqlApiRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteGraphqlApiResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteGraphqlApiResult deleteGraphqlApiResult = (DeleteGraphqlApiResult)response.getAwsResponse();
            return deleteGraphqlApiResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteResolverResult deleteResolver(DeleteResolverRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteResolver(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteResolverResult executeDeleteResolver(DeleteResolverRequest deleteResolverRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteResolverRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteResolverRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteResolverRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteResolverRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteResolverResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteResolverResult deleteResolverResult = (DeleteResolverResult)response.getAwsResponse();
            return deleteResolverResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTypeResult deleteType(DeleteTypeRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTypeResult executeDeleteType(DeleteTypeRequest deleteTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTypeRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTypeResult deleteTypeResult = (DeleteTypeResult)response.getAwsResponse();
            return deleteTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDataSourceResult getDataSource(GetDataSourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetDataSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDataSourceResult executeGetDataSource(GetDataSourceRequest getDataSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDataSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDataSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDataSourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getDataSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetDataSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDataSourceResult getDataSourceResult = (GetDataSourceResult)response.getAwsResponse();
            return getDataSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetGraphqlApiResult getGraphqlApi(GetGraphqlApiRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetGraphqlApi(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetGraphqlApiResult executeGetGraphqlApi(GetGraphqlApiRequest getGraphqlApiRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getGraphqlApiRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetGraphqlApiRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetGraphqlApiRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getGraphqlApiRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetGraphqlApiResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetGraphqlApiResult getGraphqlApiResult = (GetGraphqlApiResult)response.getAwsResponse();
            return getGraphqlApiResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetIntrospectionSchemaResult getIntrospectionSchema(GetIntrospectionSchemaRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetIntrospectionSchema(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetIntrospectionSchemaResult executeGetIntrospectionSchema(GetIntrospectionSchemaRequest getIntrospectionSchemaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIntrospectionSchemaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetIntrospectionSchemaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetIntrospectionSchemaRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getIntrospectionSchemaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(false), new GetIntrospectionSchemaResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetIntrospectionSchemaResult getIntrospectionSchemaResult = (GetIntrospectionSchemaResult)response.getAwsResponse();
            return getIntrospectionSchemaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResolverResult getResolver(GetResolverRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetResolver(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResolverResult executeGetResolver(GetResolverRequest getResolverRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResolverRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResolverRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResolverRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getResolverRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetResolverResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResolverResult getResolverResult = (GetResolverResult)response.getAwsResponse();
            return getResolverResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSchemaCreationStatusResult getSchemaCreationStatus(GetSchemaCreationStatusRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetSchemaCreationStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSchemaCreationStatusResult executeGetSchemaCreationStatus(GetSchemaCreationStatusRequest getSchemaCreationStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSchemaCreationStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSchemaCreationStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSchemaCreationStatusRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getSchemaCreationStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetSchemaCreationStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSchemaCreationStatusResult getSchemaCreationStatusResult = (GetSchemaCreationStatusResult)response.getAwsResponse();
            return getSchemaCreationStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTypeResult getType(GetTypeRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTypeResult executeGetType(GetTypeRequest getTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTypeRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTypeResult getTypeResult = (GetTypeResult)response.getAwsResponse();
            return getTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListApiKeysResult listApiKeys(ListApiKeysRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListApiKeys(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListApiKeysResult executeListApiKeys(ListApiKeysRequest listApiKeysRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listApiKeysRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListApiKeysRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListApiKeysRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listApiKeysRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListApiKeysResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListApiKeysResult listApiKeysResult = (ListApiKeysResult)response.getAwsResponse();
            return listApiKeysResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDataSourcesResult listDataSources(ListDataSourcesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListDataSources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDataSourcesResult executeListDataSources(ListDataSourcesRequest listDataSourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDataSourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDataSourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDataSourcesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listDataSourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListDataSourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDataSourcesResult listDataSourcesResult = (ListDataSourcesResult)response.getAwsResponse();
            return listDataSourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListGraphqlApisResult listGraphqlApis(ListGraphqlApisRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListGraphqlApis(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListGraphqlApisResult executeListGraphqlApis(ListGraphqlApisRequest listGraphqlApisRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listGraphqlApisRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListGraphqlApisRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListGraphqlApisRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listGraphqlApisRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListGraphqlApisResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListGraphqlApisResult listGraphqlApisResult = (ListGraphqlApisResult)response.getAwsResponse();
            return listGraphqlApisResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListResolversResult listResolvers(ListResolversRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListResolvers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListResolversResult executeListResolvers(ListResolversRequest listResolversRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listResolversRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListResolversRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListResolversRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listResolversRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListResolversResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListResolversResult listResolversResult = (ListResolversResult)response.getAwsResponse();
            return listResolversResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTypesResult listTypes(ListTypesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTypes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTypesResult executeListTypes(ListTypesRequest listTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTypesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTypesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTypesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTypesResult listTypesResult = (ListTypesResult)response.getAwsResponse();
            return listTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartSchemaCreationResult startSchemaCreation(StartSchemaCreationRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStartSchemaCreation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartSchemaCreationResult executeStartSchemaCreation(StartSchemaCreationRequest startSchemaCreationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startSchemaCreationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartSchemaCreationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartSchemaCreationRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(startSchemaCreationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StartSchemaCreationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartSchemaCreationResult startSchemaCreationResult = (StartSchemaCreationResult)response.getAwsResponse();
            return startSchemaCreationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDataSourceResult updateDataSource(UpdateDataSourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateDataSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDataSourceResult executeUpdateDataSource(UpdateDataSourceRequest updateDataSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDataSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDataSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDataSourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateDataSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateDataSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDataSourceResult updateDataSourceResult = (UpdateDataSourceResult)response.getAwsResponse();
            return updateDataSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateGraphqlApiResult updateGraphqlApi(UpdateGraphqlApiRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateGraphqlApi(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateGraphqlApiResult executeUpdateGraphqlApi(UpdateGraphqlApiRequest updateGraphqlApiRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateGraphqlApiRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateGraphqlApiRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateGraphqlApiRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateGraphqlApiRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateGraphqlApiResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateGraphqlApiResult updateGraphqlApiResult = (UpdateGraphqlApiResult)response.getAwsResponse();
            return updateGraphqlApiResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateResolverResult updateResolver(UpdateResolverRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateResolver(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateResolverResult executeUpdateResolver(UpdateResolverRequest updateResolverRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateResolverRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateResolverRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateResolverRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateResolverRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateResolverResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateResolverResult updateResolverResult = (UpdateResolverResult)response.getAwsResponse();
            return updateResolverResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateTypeResult updateType(UpdateTypeRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateTypeResult executeUpdateType(UpdateTypeRequest updateTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateTypeRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateTypeResult updateTypeResult = (UpdateTypeResult)response.getAwsResponse();
            return updateTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

