/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworkscm.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.opsworkscm.AWSOpsWorksCM;
import com.amazonaws.services.opsworkscm.model.DescribeNodeAssociationStatusRequest;
import com.amazonaws.services.opsworkscm.model.DescribeNodeAssociationStatusResult;
import com.amazonaws.services.opsworkscm.waiters.DescribeNodeAssociationStatusFunction;
import com.amazonaws.services.opsworkscm.waiters.NodeAssociated;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AWSOpsWorksCMWaiters {
    private final AWSOpsWorksCM client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AWSOpsWorksCMWaiters(AWSOpsWorksCM client) {
        this.client = client;
    }

    public Waiter<DescribeNodeAssociationStatusRequest> nodeAssociated() {
        return new WaiterBuilder<DescribeNodeAssociationStatusRequest, DescribeNodeAssociationStatusResult>().withSdkFunction(new DescribeNodeAssociationStatusFunction(this.client)).withAcceptors(new NodeAssociated.IsSUCCESSMatcher(), new NodeAssociated.IsFAILEDMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(15), new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

