/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.opsworks.model.OperatingSystemConfigurationManager;
import com.amazonaws.services.opsworks.model.transform.OperatingSystemMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class OperatingSystem
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String id;
    private String type;
    private SdkInternalList<OperatingSystemConfigurationManager> configurationManagers;
    private String reportedName;
    private String reportedVersion;
    private Boolean supported;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public OperatingSystem withName(String name) {
        this.setName(name);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public OperatingSystem withId(String id) {
        this.setId(id);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public OperatingSystem withType(String type) {
        this.setType(type);
        return this;
    }

    public List<OperatingSystemConfigurationManager> getConfigurationManagers() {
        if (this.configurationManagers == null) {
            this.configurationManagers = new SdkInternalList();
        }
        return this.configurationManagers;
    }

    public void setConfigurationManagers(Collection<OperatingSystemConfigurationManager> configurationManagers) {
        if (configurationManagers == null) {
            this.configurationManagers = null;
            return;
        }
        this.configurationManagers = new SdkInternalList<OperatingSystemConfigurationManager>(configurationManagers);
    }

    public OperatingSystem withConfigurationManagers(OperatingSystemConfigurationManager ... configurationManagers) {
        if (this.configurationManagers == null) {
            this.setConfigurationManagers(new SdkInternalList<OperatingSystemConfigurationManager>(configurationManagers.length));
        }
        for (OperatingSystemConfigurationManager ele : configurationManagers) {
            this.configurationManagers.add(ele);
        }
        return this;
    }

    public OperatingSystem withConfigurationManagers(Collection<OperatingSystemConfigurationManager> configurationManagers) {
        this.setConfigurationManagers(configurationManagers);
        return this;
    }

    public void setReportedName(String reportedName) {
        this.reportedName = reportedName;
    }

    public String getReportedName() {
        return this.reportedName;
    }

    public OperatingSystem withReportedName(String reportedName) {
        this.setReportedName(reportedName);
        return this;
    }

    public void setReportedVersion(String reportedVersion) {
        this.reportedVersion = reportedVersion;
    }

    public String getReportedVersion() {
        return this.reportedVersion;
    }

    public OperatingSystem withReportedVersion(String reportedVersion) {
        this.setReportedVersion(reportedVersion);
        return this;
    }

    public void setSupported(Boolean supported) {
        this.supported = supported;
    }

    public Boolean getSupported() {
        return this.supported;
    }

    public OperatingSystem withSupported(Boolean supported) {
        this.setSupported(supported);
        return this;
    }

    public Boolean isSupported() {
        return this.supported;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getConfigurationManagers() != null) {
            sb.append("ConfigurationManagers: ").append(this.getConfigurationManagers()).append(",");
        }
        if (this.getReportedName() != null) {
            sb.append("ReportedName: ").append(this.getReportedName()).append(",");
        }
        if (this.getReportedVersion() != null) {
            sb.append("ReportedVersion: ").append(this.getReportedVersion()).append(",");
        }
        if (this.getSupported() != null) {
            sb.append("Supported: ").append(this.getSupported());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperatingSystem)) {
            return false;
        }
        OperatingSystem other = (OperatingSystem)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getConfigurationManagers() == null ^ this.getConfigurationManagers() == null) {
            return false;
        }
        if (other.getConfigurationManagers() != null && !other.getConfigurationManagers().equals(this.getConfigurationManagers())) {
            return false;
        }
        if (other.getReportedName() == null ^ this.getReportedName() == null) {
            return false;
        }
        if (other.getReportedName() != null && !other.getReportedName().equals(this.getReportedName())) {
            return false;
        }
        if (other.getReportedVersion() == null ^ this.getReportedVersion() == null) {
            return false;
        }
        if (other.getReportedVersion() != null && !other.getReportedVersion().equals(this.getReportedVersion())) {
            return false;
        }
        if (other.getSupported() == null ^ this.getSupported() == null) {
            return false;
        }
        return other.getSupported() == null || other.getSupported().equals(this.getSupported());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationManagers() == null ? 0 : this.getConfigurationManagers().hashCode());
        hashCode = 31 * hashCode + (this.getReportedName() == null ? 0 : this.getReportedName().hashCode());
        hashCode = 31 * hashCode + (this.getReportedVersion() == null ? 0 : this.getReportedVersion().hashCode());
        hashCode = 31 * hashCode + (this.getSupported() == null ? 0 : this.getSupported().hashCode());
        return hashCode;
    }

    public OperatingSystem clone() {
        try {
            return (OperatingSystem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OperatingSystemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

