/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.Allowed;
import com.amazonaws.services.iot.model.AuthDecision;
import com.amazonaws.services.iot.model.AuthInfo;
import com.amazonaws.services.iot.model.Denied;
import com.amazonaws.services.iot.model.transform.AuthResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AuthResult
implements Serializable,
Cloneable,
StructuredPojo {
    private AuthInfo authInfo;
    private Allowed allowed;
    private Denied denied;
    private String authDecision;
    private List<String> missingContextValues;

    public void setAuthInfo(AuthInfo authInfo) {
        this.authInfo = authInfo;
    }

    public AuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public AuthResult withAuthInfo(AuthInfo authInfo) {
        this.setAuthInfo(authInfo);
        return this;
    }

    public void setAllowed(Allowed allowed) {
        this.allowed = allowed;
    }

    public Allowed getAllowed() {
        return this.allowed;
    }

    public AuthResult withAllowed(Allowed allowed) {
        this.setAllowed(allowed);
        return this;
    }

    public void setDenied(Denied denied) {
        this.denied = denied;
    }

    public Denied getDenied() {
        return this.denied;
    }

    public AuthResult withDenied(Denied denied) {
        this.setDenied(denied);
        return this;
    }

    public void setAuthDecision(String authDecision) {
        this.authDecision = authDecision;
    }

    public String getAuthDecision() {
        return this.authDecision;
    }

    public AuthResult withAuthDecision(String authDecision) {
        this.setAuthDecision(authDecision);
        return this;
    }

    public AuthResult withAuthDecision(AuthDecision authDecision) {
        this.authDecision = authDecision.toString();
        return this;
    }

    public List<String> getMissingContextValues() {
        return this.missingContextValues;
    }

    public void setMissingContextValues(Collection<String> missingContextValues) {
        if (missingContextValues == null) {
            this.missingContextValues = null;
            return;
        }
        this.missingContextValues = new ArrayList<String>(missingContextValues);
    }

    public AuthResult withMissingContextValues(String ... missingContextValues) {
        if (this.missingContextValues == null) {
            this.setMissingContextValues(new ArrayList<String>(missingContextValues.length));
        }
        for (String ele : missingContextValues) {
            this.missingContextValues.add(ele);
        }
        return this;
    }

    public AuthResult withMissingContextValues(Collection<String> missingContextValues) {
        this.setMissingContextValues(missingContextValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAuthInfo() != null) {
            sb.append("AuthInfo: ").append(this.getAuthInfo()).append(",");
        }
        if (this.getAllowed() != null) {
            sb.append("Allowed: ").append(this.getAllowed()).append(",");
        }
        if (this.getDenied() != null) {
            sb.append("Denied: ").append(this.getDenied()).append(",");
        }
        if (this.getAuthDecision() != null) {
            sb.append("AuthDecision: ").append(this.getAuthDecision()).append(",");
        }
        if (this.getMissingContextValues() != null) {
            sb.append("MissingContextValues: ").append(this.getMissingContextValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthResult)) {
            return false;
        }
        AuthResult other = (AuthResult)obj;
        if (other.getAuthInfo() == null ^ this.getAuthInfo() == null) {
            return false;
        }
        if (other.getAuthInfo() != null && !other.getAuthInfo().equals(this.getAuthInfo())) {
            return false;
        }
        if (other.getAllowed() == null ^ this.getAllowed() == null) {
            return false;
        }
        if (other.getAllowed() != null && !other.getAllowed().equals(this.getAllowed())) {
            return false;
        }
        if (other.getDenied() == null ^ this.getDenied() == null) {
            return false;
        }
        if (other.getDenied() != null && !other.getDenied().equals(this.getDenied())) {
            return false;
        }
        if (other.getAuthDecision() == null ^ this.getAuthDecision() == null) {
            return false;
        }
        if (other.getAuthDecision() != null && !other.getAuthDecision().equals(this.getAuthDecision())) {
            return false;
        }
        if (other.getMissingContextValues() == null ^ this.getMissingContextValues() == null) {
            return false;
        }
        return other.getMissingContextValues() == null || other.getMissingContextValues().equals(this.getMissingContextValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAuthInfo() == null ? 0 : this.getAuthInfo().hashCode());
        hashCode = 31 * hashCode + (this.getAllowed() == null ? 0 : this.getAllowed().hashCode());
        hashCode = 31 * hashCode + (this.getDenied() == null ? 0 : this.getDenied().hashCode());
        hashCode = 31 * hashCode + (this.getAuthDecision() == null ? 0 : this.getAuthDecision().hashCode());
        hashCode = 31 * hashCode + (this.getMissingContextValues() == null ? 0 : this.getMissingContextValues().hashCode());
        return hashCode;
    }

    public AuthResult clone() {
        try {
            return (AuthResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuthResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

