/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.apigateway.model.ApiKeySourceType;
import com.amazonaws.services.apigateway.model.EndpointConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateRestApiRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private String version;
    private String cloneFrom;
    private List<String> binaryMediaTypes;
    private Integer minimumCompressionSize;
    private String apiKeySource;
    private EndpointConfiguration endpointConfiguration;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateRestApiRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateRestApiRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public CreateRestApiRequest withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setCloneFrom(String cloneFrom) {
        this.cloneFrom = cloneFrom;
    }

    public String getCloneFrom() {
        return this.cloneFrom;
    }

    public CreateRestApiRequest withCloneFrom(String cloneFrom) {
        this.setCloneFrom(cloneFrom);
        return this;
    }

    public List<String> getBinaryMediaTypes() {
        return this.binaryMediaTypes;
    }

    public void setBinaryMediaTypes(Collection<String> binaryMediaTypes) {
        if (binaryMediaTypes == null) {
            this.binaryMediaTypes = null;
            return;
        }
        this.binaryMediaTypes = new ArrayList<String>(binaryMediaTypes);
    }

    public CreateRestApiRequest withBinaryMediaTypes(String ... binaryMediaTypes) {
        if (this.binaryMediaTypes == null) {
            this.setBinaryMediaTypes(new ArrayList<String>(binaryMediaTypes.length));
        }
        for (String ele : binaryMediaTypes) {
            this.binaryMediaTypes.add(ele);
        }
        return this;
    }

    public CreateRestApiRequest withBinaryMediaTypes(Collection<String> binaryMediaTypes) {
        this.setBinaryMediaTypes(binaryMediaTypes);
        return this;
    }

    public void setMinimumCompressionSize(Integer minimumCompressionSize) {
        this.minimumCompressionSize = minimumCompressionSize;
    }

    public Integer getMinimumCompressionSize() {
        return this.minimumCompressionSize;
    }

    public CreateRestApiRequest withMinimumCompressionSize(Integer minimumCompressionSize) {
        this.setMinimumCompressionSize(minimumCompressionSize);
        return this;
    }

    public void setApiKeySource(String apiKeySource) {
        this.apiKeySource = apiKeySource;
    }

    public String getApiKeySource() {
        return this.apiKeySource;
    }

    public CreateRestApiRequest withApiKeySource(String apiKeySource) {
        this.setApiKeySource(apiKeySource);
        return this;
    }

    public CreateRestApiRequest withApiKeySource(ApiKeySourceType apiKeySource) {
        this.apiKeySource = apiKeySource.toString();
        return this;
    }

    public void setEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public CreateRestApiRequest withEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.setEndpointConfiguration(endpointConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getCloneFrom() != null) {
            sb.append("CloneFrom: ").append(this.getCloneFrom()).append(",");
        }
        if (this.getBinaryMediaTypes() != null) {
            sb.append("BinaryMediaTypes: ").append(this.getBinaryMediaTypes()).append(",");
        }
        if (this.getMinimumCompressionSize() != null) {
            sb.append("MinimumCompressionSize: ").append(this.getMinimumCompressionSize()).append(",");
        }
        if (this.getApiKeySource() != null) {
            sb.append("ApiKeySource: ").append(this.getApiKeySource()).append(",");
        }
        if (this.getEndpointConfiguration() != null) {
            sb.append("EndpointConfiguration: ").append(this.getEndpointConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRestApiRequest)) {
            return false;
        }
        CreateRestApiRequest other = (CreateRestApiRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getCloneFrom() == null ^ this.getCloneFrom() == null) {
            return false;
        }
        if (other.getCloneFrom() != null && !other.getCloneFrom().equals(this.getCloneFrom())) {
            return false;
        }
        if (other.getBinaryMediaTypes() == null ^ this.getBinaryMediaTypes() == null) {
            return false;
        }
        if (other.getBinaryMediaTypes() != null && !other.getBinaryMediaTypes().equals(this.getBinaryMediaTypes())) {
            return false;
        }
        if (other.getMinimumCompressionSize() == null ^ this.getMinimumCompressionSize() == null) {
            return false;
        }
        if (other.getMinimumCompressionSize() != null && !other.getMinimumCompressionSize().equals(this.getMinimumCompressionSize())) {
            return false;
        }
        if (other.getApiKeySource() == null ^ this.getApiKeySource() == null) {
            return false;
        }
        if (other.getApiKeySource() != null && !other.getApiKeySource().equals(this.getApiKeySource())) {
            return false;
        }
        if (other.getEndpointConfiguration() == null ^ this.getEndpointConfiguration() == null) {
            return false;
        }
        return other.getEndpointConfiguration() == null || other.getEndpointConfiguration().equals(this.getEndpointConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getCloneFrom() == null ? 0 : this.getCloneFrom().hashCode());
        hashCode = 31 * hashCode + (this.getBinaryMediaTypes() == null ? 0 : this.getBinaryMediaTypes().hashCode());
        hashCode = 31 * hashCode + (this.getMinimumCompressionSize() == null ? 0 : this.getMinimumCompressionSize().hashCode());
        hashCode = 31 * hashCode + (this.getApiKeySource() == null ? 0 : this.getApiKeySource().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointConfiguration() == null ? 0 : this.getEndpointConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public CreateRestApiRequest clone() {
        return (CreateRestApiRequest)super.clone();
    }
}

