/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mq.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mq.model.ChangeType;
import com.amazonaws.services.mq.model.transform.UserPendingChangesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UserPendingChanges
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean consoleAccess;
    private List<String> groups;
    private String pendingChange;

    public void setConsoleAccess(Boolean consoleAccess) {
        this.consoleAccess = consoleAccess;
    }

    public Boolean getConsoleAccess() {
        return this.consoleAccess;
    }

    public UserPendingChanges withConsoleAccess(Boolean consoleAccess) {
        this.setConsoleAccess(consoleAccess);
        return this;
    }

    public Boolean isConsoleAccess() {
        return this.consoleAccess;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new ArrayList<String>(groups);
    }

    public UserPendingChanges withGroups(String ... groups) {
        if (this.groups == null) {
            this.setGroups(new ArrayList<String>(groups.length));
        }
        for (String ele : groups) {
            this.groups.add(ele);
        }
        return this;
    }

    public UserPendingChanges withGroups(Collection<String> groups) {
        this.setGroups(groups);
        return this;
    }

    public void setPendingChange(String pendingChange) {
        this.pendingChange = pendingChange;
    }

    public String getPendingChange() {
        return this.pendingChange;
    }

    public UserPendingChanges withPendingChange(String pendingChange) {
        this.setPendingChange(pendingChange);
        return this;
    }

    public UserPendingChanges withPendingChange(ChangeType pendingChange) {
        this.pendingChange = pendingChange.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConsoleAccess() != null) {
            sb.append("ConsoleAccess: ").append(this.getConsoleAccess()).append(",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: ").append(this.getGroups()).append(",");
        }
        if (this.getPendingChange() != null) {
            sb.append("PendingChange: ").append(this.getPendingChange());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPendingChanges)) {
            return false;
        }
        UserPendingChanges other = (UserPendingChanges)obj;
        if (other.getConsoleAccess() == null ^ this.getConsoleAccess() == null) {
            return false;
        }
        if (other.getConsoleAccess() != null && !other.getConsoleAccess().equals(this.getConsoleAccess())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getPendingChange() == null ^ this.getPendingChange() == null) {
            return false;
        }
        return other.getPendingChange() == null || other.getPendingChange().equals(this.getPendingChange());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConsoleAccess() == null ? 0 : this.getConsoleAccess().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getPendingChange() == null ? 0 : this.getPendingChange().hashCode());
        return hashCode;
    }

    public UserPendingChanges clone() {
        try {
            return (UserPendingChanges)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserPendingChangesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

