/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelbuilding.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lexmodelbuilding.model.UtteranceData;
import java.util.Date;

@SdkInternalApi
public class UtteranceDataMarshaller {
    private static final MarshallingInfo<String> UTTERANCESTRING_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("utteranceString").build();
    private static final MarshallingInfo<Integer> COUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("count").build();
    private static final MarshallingInfo<Integer> DISTINCTUSERS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("distinctUsers").build();
    private static final MarshallingInfo<Date> FIRSTUTTEREDDATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firstUtteredDate").build();
    private static final MarshallingInfo<Date> LASTUTTEREDDATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUtteredDate").build();
    private static final UtteranceDataMarshaller instance = new UtteranceDataMarshaller();

    public static UtteranceDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(UtteranceData utteranceData, ProtocolMarshaller protocolMarshaller) {
        if (utteranceData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(utteranceData.getUtteranceString(), UTTERANCESTRING_BINDING);
            protocolMarshaller.marshall(utteranceData.getCount(), COUNT_BINDING);
            protocolMarshaller.marshall(utteranceData.getDistinctUsers(), DISTINCTUSERS_BINDING);
            protocolMarshaller.marshall(utteranceData.getFirstUtteredDate(), FIRSTUTTEREDDATE_BINDING);
            protocolMarshaller.marshall(utteranceData.getLastUtteredDate(), LASTUTTEREDDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

