/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dax.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.dax.model.Parameter;
import java.util.List;

@SdkInternalApi
public class ParameterMarshaller {
    private static final MarshallingInfo<String> PARAMETERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterName").build();
    private static final MarshallingInfo<String> PARAMETERTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterType").build();
    private static final MarshallingInfo<String> PARAMETERVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterValue").build();
    private static final MarshallingInfo<List> NODETYPESPECIFICVALUES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeTypeSpecificValues").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> SOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Source").build();
    private static final MarshallingInfo<String> DATATYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataType").build();
    private static final MarshallingInfo<String> ALLOWEDVALUES_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedValues").build();
    private static final MarshallingInfo<String> ISMODIFIABLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsModifiable").build();
    private static final MarshallingInfo<String> CHANGETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChangeType").build();
    private static final ParameterMarshaller instance = new ParameterMarshaller();

    public static ParameterMarshaller getInstance() {
        return instance;
    }

    public void marshall(Parameter parameter, ProtocolMarshaller protocolMarshaller) {
        if (parameter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(parameter.getParameterName(), PARAMETERNAME_BINDING);
            protocolMarshaller.marshall(parameter.getParameterType(), PARAMETERTYPE_BINDING);
            protocolMarshaller.marshall(parameter.getParameterValue(), PARAMETERVALUE_BINDING);
            protocolMarshaller.marshall(parameter.getNodeTypeSpecificValues(), NODETYPESPECIFICVALUES_BINDING);
            protocolMarshaller.marshall(parameter.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(parameter.getSource(), SOURCE_BINDING);
            protocolMarshaller.marshall(parameter.getDataType(), DATATYPE_BINDING);
            protocolMarshaller.marshall(parameter.getAllowedValues(), ALLOWEDVALUES_BINDING);
            protocolMarshaller.marshall(parameter.getIsModifiable(), ISMODIFIABLE_BINDING);
            protocolMarshaller.marshall(parameter.getChangeType(), CHANGETYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

