/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.ArrayPropertiesDetail;
import com.amazonaws.services.batch.model.AttemptDetail;
import com.amazonaws.services.batch.model.ContainerDetail;
import com.amazonaws.services.batch.model.JobDependency;
import com.amazonaws.services.batch.model.JobStatus;
import com.amazonaws.services.batch.model.RetryStrategy;
import com.amazonaws.services.batch.model.transform.JobDetailMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JobDetail
implements Serializable,
Cloneable,
StructuredPojo {
    private String jobName;
    private String jobId;
    private String jobQueue;
    private String status;
    private List<AttemptDetail> attempts;
    private String statusReason;
    private Long createdAt;
    private RetryStrategy retryStrategy;
    private Long startedAt;
    private Long stoppedAt;
    private List<JobDependency> dependsOn;
    private String jobDefinition;
    private Map<String, String> parameters;
    private ContainerDetail container;
    private ArrayPropertiesDetail arrayProperties;

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public JobDetail withJobName(String jobName) {
        this.setJobName(jobName);
        return this;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public JobDetail withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public void setJobQueue(String jobQueue) {
        this.jobQueue = jobQueue;
    }

    public String getJobQueue() {
        return this.jobQueue;
    }

    public JobDetail withJobQueue(String jobQueue) {
        this.setJobQueue(jobQueue);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public JobDetail withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(JobStatus status) {
        this.withStatus(status);
    }

    public JobDetail withStatus(JobStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<AttemptDetail> getAttempts() {
        return this.attempts;
    }

    public void setAttempts(Collection<AttemptDetail> attempts) {
        if (attempts == null) {
            this.attempts = null;
            return;
        }
        this.attempts = new ArrayList<AttemptDetail>(attempts);
    }

    public JobDetail withAttempts(AttemptDetail ... attempts) {
        if (this.attempts == null) {
            this.setAttempts(new ArrayList<AttemptDetail>(attempts.length));
        }
        for (AttemptDetail ele : attempts) {
            this.attempts.add(ele);
        }
        return this;
    }

    public JobDetail withAttempts(Collection<AttemptDetail> attempts) {
        this.setAttempts(attempts);
        return this;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public JobDetail withStatusReason(String statusReason) {
        this.setStatusReason(statusReason);
        return this;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public JobDetail withCreatedAt(Long createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setRetryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public JobDetail withRetryStrategy(RetryStrategy retryStrategy) {
        this.setRetryStrategy(retryStrategy);
        return this;
    }

    public void setStartedAt(Long startedAt) {
        this.startedAt = startedAt;
    }

    public Long getStartedAt() {
        return this.startedAt;
    }

    public JobDetail withStartedAt(Long startedAt) {
        this.setStartedAt(startedAt);
        return this;
    }

    public void setStoppedAt(Long stoppedAt) {
        this.stoppedAt = stoppedAt;
    }

    public Long getStoppedAt() {
        return this.stoppedAt;
    }

    public JobDetail withStoppedAt(Long stoppedAt) {
        this.setStoppedAt(stoppedAt);
        return this;
    }

    public List<JobDependency> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(Collection<JobDependency> dependsOn) {
        if (dependsOn == null) {
            this.dependsOn = null;
            return;
        }
        this.dependsOn = new ArrayList<JobDependency>(dependsOn);
    }

    public JobDetail withDependsOn(JobDependency ... dependsOn) {
        if (this.dependsOn == null) {
            this.setDependsOn(new ArrayList<JobDependency>(dependsOn.length));
        }
        for (JobDependency ele : dependsOn) {
            this.dependsOn.add(ele);
        }
        return this;
    }

    public JobDetail withDependsOn(Collection<JobDependency> dependsOn) {
        this.setDependsOn(dependsOn);
        return this;
    }

    public void setJobDefinition(String jobDefinition) {
        this.jobDefinition = jobDefinition;
    }

    public String getJobDefinition() {
        return this.jobDefinition;
    }

    public JobDetail withJobDefinition(String jobDefinition) {
        this.setJobDefinition(jobDefinition);
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public JobDetail withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public JobDetail addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public JobDetail clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setContainer(ContainerDetail container) {
        this.container = container;
    }

    public ContainerDetail getContainer() {
        return this.container;
    }

    public JobDetail withContainer(ContainerDetail container) {
        this.setContainer(container);
        return this;
    }

    public void setArrayProperties(ArrayPropertiesDetail arrayProperties) {
        this.arrayProperties = arrayProperties;
    }

    public ArrayPropertiesDetail getArrayProperties() {
        return this.arrayProperties;
    }

    public JobDetail withArrayProperties(ArrayPropertiesDetail arrayProperties) {
        this.setArrayProperties(arrayProperties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobName() != null) {
            sb.append("JobName: ").append(this.getJobName()).append(",");
        }
        if (this.getJobId() != null) {
            sb.append("JobId: ").append(this.getJobId()).append(",");
        }
        if (this.getJobQueue() != null) {
            sb.append("JobQueue: ").append(this.getJobQueue()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getAttempts() != null) {
            sb.append("Attempts: ").append(this.getAttempts()).append(",");
        }
        if (this.getStatusReason() != null) {
            sb.append("StatusReason: ").append(this.getStatusReason()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getRetryStrategy() != null) {
            sb.append("RetryStrategy: ").append(this.getRetryStrategy()).append(",");
        }
        if (this.getStartedAt() != null) {
            sb.append("StartedAt: ").append(this.getStartedAt()).append(",");
        }
        if (this.getStoppedAt() != null) {
            sb.append("StoppedAt: ").append(this.getStoppedAt()).append(",");
        }
        if (this.getDependsOn() != null) {
            sb.append("DependsOn: ").append(this.getDependsOn()).append(",");
        }
        if (this.getJobDefinition() != null) {
            sb.append("JobDefinition: ").append(this.getJobDefinition()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getContainer() != null) {
            sb.append("Container: ").append(this.getContainer()).append(",");
        }
        if (this.getArrayProperties() != null) {
            sb.append("ArrayProperties: ").append(this.getArrayProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDetail)) {
            return false;
        }
        JobDetail other = (JobDetail)obj;
        if (other.getJobName() == null ^ this.getJobName() == null) {
            return false;
        }
        if (other.getJobName() != null && !other.getJobName().equals(this.getJobName())) {
            return false;
        }
        if (other.getJobId() == null ^ this.getJobId() == null) {
            return false;
        }
        if (other.getJobId() != null && !other.getJobId().equals(this.getJobId())) {
            return false;
        }
        if (other.getJobQueue() == null ^ this.getJobQueue() == null) {
            return false;
        }
        if (other.getJobQueue() != null && !other.getJobQueue().equals(this.getJobQueue())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getAttempts() == null ^ this.getAttempts() == null) {
            return false;
        }
        if (other.getAttempts() != null && !other.getAttempts().equals(this.getAttempts())) {
            return false;
        }
        if (other.getStatusReason() == null ^ this.getStatusReason() == null) {
            return false;
        }
        if (other.getStatusReason() != null && !other.getStatusReason().equals(this.getStatusReason())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getRetryStrategy() == null ^ this.getRetryStrategy() == null) {
            return false;
        }
        if (other.getRetryStrategy() != null && !other.getRetryStrategy().equals(this.getRetryStrategy())) {
            return false;
        }
        if (other.getStartedAt() == null ^ this.getStartedAt() == null) {
            return false;
        }
        if (other.getStartedAt() != null && !other.getStartedAt().equals(this.getStartedAt())) {
            return false;
        }
        if (other.getStoppedAt() == null ^ this.getStoppedAt() == null) {
            return false;
        }
        if (other.getStoppedAt() != null && !other.getStoppedAt().equals(this.getStoppedAt())) {
            return false;
        }
        if (other.getDependsOn() == null ^ this.getDependsOn() == null) {
            return false;
        }
        if (other.getDependsOn() != null && !other.getDependsOn().equals(this.getDependsOn())) {
            return false;
        }
        if (other.getJobDefinition() == null ^ this.getJobDefinition() == null) {
            return false;
        }
        if (other.getJobDefinition() != null && !other.getJobDefinition().equals(this.getJobDefinition())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getContainer() == null ^ this.getContainer() == null) {
            return false;
        }
        if (other.getContainer() != null && !other.getContainer().equals(this.getContainer())) {
            return false;
        }
        if (other.getArrayProperties() == null ^ this.getArrayProperties() == null) {
            return false;
        }
        return other.getArrayProperties() == null || other.getArrayProperties().equals(this.getArrayProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobName() == null ? 0 : this.getJobName().hashCode());
        hashCode = 31 * hashCode + (this.getJobId() == null ? 0 : this.getJobId().hashCode());
        hashCode = 31 * hashCode + (this.getJobQueue() == null ? 0 : this.getJobQueue().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAttempts() == null ? 0 : this.getAttempts().hashCode());
        hashCode = 31 * hashCode + (this.getStatusReason() == null ? 0 : this.getStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getRetryStrategy() == null ? 0 : this.getRetryStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getStartedAt() == null ? 0 : this.getStartedAt().hashCode());
        hashCode = 31 * hashCode + (this.getStoppedAt() == null ? 0 : this.getStoppedAt().hashCode());
        hashCode = 31 * hashCode + (this.getDependsOn() == null ? 0 : this.getDependsOn().hashCode());
        hashCode = 31 * hashCode + (this.getJobDefinition() == null ? 0 : this.getJobDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getContainer() == null ? 0 : this.getContainer().hashCode());
        hashCode = 31 * hashCode + (this.getArrayProperties() == null ? 0 : this.getArrayProperties().hashCode());
        return hashCode;
    }

    public JobDetail clone() {
        try {
            return (JobDetail)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

