/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.alexaforbusiness.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.alexaforbusiness.model.Filter;
import com.amazonaws.services.alexaforbusiness.model.Sort;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchUsersRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String nextToken;
    private Integer maxResults;
    private List<Filter> filters;
    private List<Sort> sortCriteria;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public SearchUsersRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public SearchUsersRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<Filter>(filters);
    }

    public SearchUsersRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public SearchUsersRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public List<Sort> getSortCriteria() {
        return this.sortCriteria;
    }

    public void setSortCriteria(Collection<Sort> sortCriteria) {
        if (sortCriteria == null) {
            this.sortCriteria = null;
            return;
        }
        this.sortCriteria = new ArrayList<Sort>(sortCriteria);
    }

    public SearchUsersRequest withSortCriteria(Sort ... sortCriteria) {
        if (this.sortCriteria == null) {
            this.setSortCriteria(new ArrayList<Sort>(sortCriteria.length));
        }
        for (Sort ele : sortCriteria) {
            this.sortCriteria.add(ele);
        }
        return this;
    }

    public SearchUsersRequest withSortCriteria(Collection<Sort> sortCriteria) {
        this.setSortCriteria(sortCriteria);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getSortCriteria() != null) {
            sb.append("SortCriteria: ").append(this.getSortCriteria());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchUsersRequest)) {
            return false;
        }
        SearchUsersRequest other = (SearchUsersRequest)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getSortCriteria() == null ^ this.getSortCriteria() == null) {
            return false;
        }
        return other.getSortCriteria() == null || other.getSortCriteria().equals(this.getSortCriteria());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getSortCriteria() == null ? 0 : this.getSortCriteria().hashCode());
        return hashCode;
    }

    @Override
    public SearchUsersRequest clone() {
        return (SearchUsersRequest)super.clone();
    }
}

