/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.lambda.model.GetAliasRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetAliasRequestMarshaller
implements Marshaller<Request<GetAliasRequest>, GetAliasRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetAliasRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetAliasRequest> marshall(GetAliasRequest getAliasRequest) {
        if (getAliasRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetAliasRequest> request = new DefaultRequest<GetAliasRequest>(getAliasRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/aliases/{Name}";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", getAliasRequest.getFunctionName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getAliasRequest.getFunctionName()), false) : "");
        uriResourcePath = uriResourcePath.replace("{Name}", getAliasRequest.getName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getAliasRequest.getName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

