/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.sagemaker.model.DescribeEndpointResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class Endpoint_Updated {
    Endpoint_Updated() {
    }

    static class IsValidationExceptionMatcher
    extends WaiterAcceptor<DescribeEndpointResult> {
        IsValidationExceptionMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "ValidationException".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }
    }

    static class IsThrottlingExceptionMatcher
    extends WaiterAcceptor<DescribeEndpointResult> {
        IsThrottlingExceptionMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "ThrottlingException".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }
    }

    static class IsFailedMatcher
    extends WaiterAcceptor<DescribeEndpointResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsFailedMatcher() {
        }

        @Override
        public boolean matches(DescribeEndpointResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Failed\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("EndpointStatus");
        }
    }

    static class IsRollingBackMatcher
    extends WaiterAcceptor<DescribeEndpointResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsRollingBackMatcher() {
        }

        @Override
        public boolean matches(DescribeEndpointResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"RollingBack\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("EndpointStatus");
        }
    }

    static class IsUpdatingMatcher
    extends WaiterAcceptor<DescribeEndpointResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsUpdatingMatcher() {
        }

        @Override
        public boolean matches(DescribeEndpointResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Updating\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("EndpointStatus");
        }
    }

    static class Is200Matcher
    extends WaiterAcceptor<DescribeEndpointResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        Is200Matcher() {
        }

        @Override
        public boolean matches(DescribeEndpointResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"200\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("EndpointName");
        }
    }
}

