/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpoint.model.AddressConfiguration;
import java.util.Map;

@SdkInternalApi
public class AddressConfigurationMarshaller {
    private static final MarshallingInfo<String> BODYOVERRIDE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BodyOverride").build();
    private static final MarshallingInfo<String> CHANNELTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChannelType").build();
    private static final MarshallingInfo<Map> CONTEXT_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Context").build();
    private static final MarshallingInfo<String> RAWCONTENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RawContent").build();
    private static final MarshallingInfo<Map> SUBSTITUTIONS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Substitutions").build();
    private static final MarshallingInfo<String> TITLEOVERRIDE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TitleOverride").build();
    private static final AddressConfigurationMarshaller instance = new AddressConfigurationMarshaller();

    public static AddressConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(AddressConfiguration addressConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (addressConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(addressConfiguration.getBodyOverride(), BODYOVERRIDE_BINDING);
            protocolMarshaller.marshall(addressConfiguration.getChannelType(), CHANNELTYPE_BINDING);
            protocolMarshaller.marshall(addressConfiguration.getContext(), CONTEXT_BINDING);
            protocolMarshaller.marshall(addressConfiguration.getRawContent(), RAWCONTENT_BINDING);
            protocolMarshaller.marshall(addressConfiguration.getSubstitutions(), SUBSTITUTIONS_BINDING);
            protocolMarshaller.marshall(addressConfiguration.getTitleOverride(), TITLEOVERRIDE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

