/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.StackSetOperationPreferences;
import com.amazonaws.services.cloudformation.model.UpdateStackInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class UpdateStackInstancesRequestMarshaller
implements Marshaller<Request<UpdateStackInstancesRequest>, UpdateStackInstancesRequest> {
    @Override
    public Request<UpdateStackInstancesRequest> marshall(UpdateStackInstancesRequest updateStackInstancesRequest) {
        StackSetOperationPreferences operationPreferences;
        SdkInternalList parameterOverridesList;
        SdkInternalList regionsList;
        SdkInternalList accountsList;
        if (updateStackInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateStackInstancesRequest> request = new DefaultRequest<UpdateStackInstancesRequest>(updateStackInstancesRequest, "AmazonCloudFormation");
        request.addParameter("Action", "UpdateStackInstances");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateStackInstancesRequest.getStackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString(updateStackInstancesRequest.getStackSetName()));
        }
        if ((accountsList = (SdkInternalList)updateStackInstancesRequest.getAccounts()).isEmpty() && !accountsList.isAutoConstruct()) {
            request.addParameter("Accounts", "");
        }
        if (!accountsList.isEmpty() || !accountsList.isAutoConstruct()) {
            int accountsListIndex = 1;
            for (Object accountsListValue : accountsList) {
                if (accountsListValue != null) {
                    request.addParameter("Accounts.member." + accountsListIndex, StringUtils.fromString((String)accountsListValue));
                }
                ++accountsListIndex;
            }
        }
        if ((regionsList = (SdkInternalList)updateStackInstancesRequest.getRegions()).isEmpty() && !regionsList.isAutoConstruct()) {
            request.addParameter("Regions", "");
        }
        if (!regionsList.isEmpty() || !regionsList.isAutoConstruct()) {
            int regionsListIndex = 1;
            for (Object regionsListValue : regionsList) {
                if (regionsListValue != null) {
                    request.addParameter("Regions.member." + regionsListIndex, StringUtils.fromString((String)regionsListValue));
                }
                ++regionsListIndex;
            }
        }
        if ((parameterOverridesList = (SdkInternalList)updateStackInstancesRequest.getParameterOverrides()).isEmpty() && !parameterOverridesList.isAutoConstruct()) {
            request.addParameter("ParameterOverrides", "");
        }
        if (!parameterOverridesList.isEmpty() || !parameterOverridesList.isAutoConstruct()) {
            int parameterOverridesListIndex = 1;
            for (Parameter parameterOverridesListValue : parameterOverridesList) {
                if (parameterOverridesListValue.getParameterKey() != null) {
                    request.addParameter("ParameterOverrides.member." + parameterOverridesListIndex + ".ParameterKey", StringUtils.fromString(parameterOverridesListValue.getParameterKey()));
                }
                if (parameterOverridesListValue.getParameterValue() != null) {
                    request.addParameter("ParameterOverrides.member." + parameterOverridesListIndex + ".ParameterValue", StringUtils.fromString(parameterOverridesListValue.getParameterValue()));
                }
                if (parameterOverridesListValue.getUsePreviousValue() != null) {
                    request.addParameter("ParameterOverrides.member." + parameterOverridesListIndex + ".UsePreviousValue", StringUtils.fromBoolean(parameterOverridesListValue.getUsePreviousValue()));
                }
                if (parameterOverridesListValue.getResolvedValue() != null) {
                    request.addParameter("ParameterOverrides.member." + parameterOverridesListIndex + ".ResolvedValue", StringUtils.fromString(parameterOverridesListValue.getResolvedValue()));
                }
                ++parameterOverridesListIndex;
            }
        }
        if ((operationPreferences = updateStackInstancesRequest.getOperationPreferences()) != null) {
            SdkInternalList regionOrderList = (SdkInternalList)operationPreferences.getRegionOrder();
            if (regionOrderList.isEmpty() && !regionOrderList.isAutoConstruct()) {
                request.addParameter("OperationPreferences.RegionOrder", "");
            }
            if (!regionOrderList.isEmpty() || !regionOrderList.isAutoConstruct()) {
                int regionOrderListIndex = 1;
                for (String regionOrderListValue : regionOrderList) {
                    if (regionOrderListValue != null) {
                        request.addParameter("OperationPreferences.RegionOrder.member." + regionOrderListIndex, StringUtils.fromString(regionOrderListValue));
                    }
                    ++regionOrderListIndex;
                }
            }
            if (operationPreferences.getFailureToleranceCount() != null) {
                request.addParameter("OperationPreferences.FailureToleranceCount", StringUtils.fromInteger(operationPreferences.getFailureToleranceCount()));
            }
            if (operationPreferences.getFailureTolerancePercentage() != null) {
                request.addParameter("OperationPreferences.FailureTolerancePercentage", StringUtils.fromInteger(operationPreferences.getFailureTolerancePercentage()));
            }
            if (operationPreferences.getMaxConcurrentCount() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentCount", StringUtils.fromInteger(operationPreferences.getMaxConcurrentCount()));
            }
            if (operationPreferences.getMaxConcurrentPercentage() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentPercentage", StringUtils.fromInteger(operationPreferences.getMaxConcurrentPercentage()));
            }
        }
        request.addParameter("OperationId", IdempotentUtils.resolveString(updateStackInstancesRequest.getOperationId()));
        return request;
    }
}

