/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.Tag;
import com.amazonaws.services.elasticbeanstalk.model.UpdateTagsForResourceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UpdateTagsForResourceRequestMarshaller
implements Marshaller<Request<UpdateTagsForResourceRequest>, UpdateTagsForResourceRequest> {
    @Override
    public Request<UpdateTagsForResourceRequest> marshall(UpdateTagsForResourceRequest updateTagsForResourceRequest) {
        SdkInternalList tagsToRemoveList;
        SdkInternalList tagsToAddList;
        if (updateTagsForResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateTagsForResourceRequest> request = new DefaultRequest<UpdateTagsForResourceRequest>(updateTagsForResourceRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "UpdateTagsForResource");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateTagsForResourceRequest.getResourceArn() != null) {
            request.addParameter("ResourceArn", StringUtils.fromString(updateTagsForResourceRequest.getResourceArn()));
        }
        if (!(tagsToAddList = (SdkInternalList)updateTagsForResourceRequest.getTagsToAdd()).isEmpty() || !tagsToAddList.isAutoConstruct()) {
            int tagsToAddListIndex = 1;
            for (Tag tagsToAddListValue : tagsToAddList) {
                if (tagsToAddListValue.getKey() != null) {
                    request.addParameter("TagsToAdd.member." + tagsToAddListIndex + ".Key", StringUtils.fromString(tagsToAddListValue.getKey()));
                }
                if (tagsToAddListValue.getValue() != null) {
                    request.addParameter("TagsToAdd.member." + tagsToAddListIndex + ".Value", StringUtils.fromString(tagsToAddListValue.getValue()));
                }
                ++tagsToAddListIndex;
            }
        }
        if (!(tagsToRemoveList = (SdkInternalList)updateTagsForResourceRequest.getTagsToRemove()).isEmpty() || !tagsToRemoveList.isAutoConstruct()) {
            int tagsToRemoveListIndex = 1;
            for (String tagsToRemoveListValue : tagsToRemoveList) {
                if (tagsToRemoveListValue != null) {
                    request.addParameter("TagsToRemove.member." + tagsToRemoveListIndex, StringUtils.fromString(tagsToRemoveListValue));
                }
                ++tagsToRemoveListIndex;
            }
        }
        return request;
    }
}

