/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.CreateStackSetRequest;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateStackSetRequestMarshaller
implements Marshaller<Request<CreateStackSetRequest>, CreateStackSetRequest> {
    @Override
    public Request<CreateStackSetRequest> marshall(CreateStackSetRequest createStackSetRequest) {
        SdkInternalList tagsList;
        SdkInternalList capabilitiesList;
        SdkInternalList parametersList;
        if (createStackSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateStackSetRequest> request = new DefaultRequest<CreateStackSetRequest>(createStackSetRequest, "AmazonCloudFormation");
        request.addParameter("Action", "CreateStackSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createStackSetRequest.getStackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString(createStackSetRequest.getStackSetName()));
        }
        if (createStackSetRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createStackSetRequest.getDescription()));
        }
        if (createStackSetRequest.getTemplateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString(createStackSetRequest.getTemplateBody()));
        }
        if (createStackSetRequest.getTemplateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString(createStackSetRequest.getTemplateURL()));
        }
        if ((parametersList = (SdkInternalList)createStackSetRequest.getParameters()).isEmpty() && !parametersList.isAutoConstruct()) {
            request.addParameter("Parameters", "");
        }
        if (!parametersList.isEmpty() || !parametersList.isAutoConstruct()) {
            int parametersListIndex = 1;
            for (Object parametersListValue : parametersList) {
                if (((Parameter)parametersListValue).getParameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString(((Parameter)parametersListValue).getParameterKey()));
                }
                if (((Parameter)parametersListValue).getParameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString(((Parameter)parametersListValue).getParameterValue()));
                }
                if (((Parameter)parametersListValue).getUsePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean(((Parameter)parametersListValue).getUsePreviousValue()));
                }
                ++parametersListIndex;
            }
        }
        if ((capabilitiesList = (SdkInternalList)createStackSetRequest.getCapabilities()).isEmpty() && !capabilitiesList.isAutoConstruct()) {
            request.addParameter("Capabilities", "");
        }
        if (!capabilitiesList.isEmpty() || !capabilitiesList.isAutoConstruct()) {
            int capabilitiesListIndex = 1;
            for (String capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex, StringUtils.fromString(capabilitiesListValue));
                }
                ++capabilitiesListIndex;
            }
        }
        if ((tagsList = (SdkInternalList)createStackSetRequest.getTags()).isEmpty() && !tagsList.isAutoConstruct()) {
            request.addParameter("Tags", "");
        }
        if (!tagsList.isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        request.addParameter("ClientRequestToken", IdempotentUtils.resolveString(createStackSetRequest.getClientRequestToken()));
        return request;
    }
}

