/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchema;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchemas;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperModelFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperValueConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.ItemConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.S3ClientCache;
import com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardAnnotationMaps;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardAttributeTypes;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardBeanProperties;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardParameterTypes;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@SdkInternalApi
final class StandardModelFactories {
    StandardModelFactories() {
    }

    static final DynamoDBMapperModelFactory.Factory of(ConversionSchema.Dependencies depends) {
        return new SchemaFactoryFactory(depends);
    }

    private static final class Conversions<T> {
        private static final DynamoDBTypeConverter.Factory converters = StandardTypeConverters.factory();
        private final StandardTypeConverters.ConvertToMap<T, DynamoDBMapperValueConverter<T>> scalars = new StandardTypeConverters.ConvertToMap();
        private final StandardTypeConverters.ConvertToMap<T, DynamoDBMapperValueConverter<T>> sets = new StandardTypeConverters.ConvertToMap();
        private final DynamoDBMapperModelFactory models;

        private Conversions(DynamoDBMapperModelFactory models) {
            this.models = models;
            for (StandardTypeConverters.Scalar target : StandardTypeConverters.Scalar.values()) {
                ScalarAttributeType scalar = target.scalarType();
                if (scalar == null) continue;
                DynamoDBTypeConverter converter = converters.getConverter(target.type());
                this.sets.with(target.type(), StandardAttributeTypes.AttributeType.valueOf(scalar.name() + "S").join(StandardTypeConverters.Vector.SET.wrap(converter)));
                this.scalars.with(target.type(), StandardAttributeTypes.AttributeType.valueOf(scalar.name()).join(converter));
                if (target.primitiveType() == null) continue;
                this.scalars.with(target.primitiveType(), this.scalars.get(target.type()));
            }
            this.sets.with(Object.class, StandardAttributeTypes.AttributeType.SS.join(StandardTypeConverters.Vector.SET.wrap(StandardTypeConverters.Scalar.STRING.getConverter(Object.class))));
        }

        public DynamoDBMapperValueConverter<T> getConverter(final StandardParameterTypes.ParamType<T> type) {
            if (StandardTypeConverters.Vector.SET.is(type.type())) {
                DynamoDBMapperValueConverter<T> converter = this.sets.from(type.param(0).type());
                if (converter == StandardAttributeTypes.AttributeType.L) {
                    return StandardAttributeTypes.AttributeType.L.join(StandardTypeConverters.Vector.SET.wrap(StandardAttributeTypes.AttributeType.NULL.wrap(this.getConverter(type.param(0)))));
                }
                if (converter != null) {
                    return converter;
                }
            } else {
                DynamoDBMapperValueConverter<T> converter = this.scalars.from(type.type());
                if (converter == StandardAttributeTypes.AttributeType.L) {
                    if (type.param(0) != null) {
                        return StandardAttributeTypes.AttributeType.L.join(StandardTypeConverters.Vector.LIST.wrap(StandardAttributeTypes.AttributeType.NULL.wrap(this.getConverter(type.param(0)))));
                    }
                } else if (converter == StandardAttributeTypes.AttributeType.M) {
                    if (StandardTypeConverters.Vector.MAP.is(type.type()) && type.param(1) != null && StandardTypeConverters.Scalar.STRING.is(type.param(0).type())) {
                        return StandardAttributeTypes.AttributeType.M.join(StandardTypeConverters.Vector.MAP.wrap(StandardAttributeTypes.AttributeType.NULL.wrap(this.getConverter(type.param(1)))));
                    }
                    if (StandardAnnotationMaps.of(type.type()).document() != null) {
                        return StandardAttributeTypes.AttributeType.M.join(new DynamoDBTypeConverter<Map<String, AttributeValue>, T>(){

                            @Override
                            public final Map<String, AttributeValue> convert(T o) {
                                return Conversions.this.models.getTableModel(type.type()).convert(o);
                            }

                            @Override
                            public final T unconvert(Map<String, AttributeValue> o) {
                                return Conversions.this.models.getTableModel(type.type()).unconvert(o);
                            }
                        });
                    }
                } else if (converter != null) {
                    return converter;
                }
            }
            return StandardAttributeTypes.AttributeType.M.wrap(new DynamoDBTypeConverter<AttributeValue, T>(){

                @Override
                public final AttributeValue convert(T o) {
                    throw new DynamoDBMappingException("type [" + type.type() + "] is not supported; requires @DynamoDBDocument or @DynamoDBTypeConverted");
                }

                @Override
                public final T unconvert(AttributeValue o) {
                    throw new DynamoDBMappingException("type [" + type.type() + "] is not supported; requires @DynamoDBDocument or @DynamoDBTypeConverted");
                }
            });
        }

        public Conversions with(final ConversionSchema.Dependencies depends) {
            this.scalars.with(S3Link.class, StandardAttributeTypes.AttributeType.S.join(new DynamoDBTypeConverter<String, S3Link>(){

                @Override
                public final String convert(S3Link o) {
                    return o.getBucketName() == null || o.getKey() == null ? null : o.toJson();
                }

                @Override
                public final S3Link unconvert(String o) {
                    return S3Link.fromJson(depends.get(S3ClientCache.class), o);
                }
            }));
            return this;
        }

        public Conversions with(ConversionSchema schema) {
            if (schema == ConversionSchemas.V2 || schema == ConversionSchemas.V2_COMPATIBLE) {
                this.scalars.with(List.class, StandardAttributeTypes.AttributeType.L.converter());
                this.scalars.with(Map.class, StandardAttributeTypes.AttributeType.M.converter());
                this.scalars.with(Object.class, StandardAttributeTypes.AttributeType.M.converter());
            }
            if (schema == ConversionSchemas.V2) {
                this.scalars.with(Boolean.class, StandardAttributeTypes.AttributeType.BOOL.converter());
                this.scalars.with(Boolean.TYPE, StandardAttributeTypes.AttributeType.BOOL.converter());
                this.sets.with(Boolean.class, StandardAttributeTypes.join(new DynamoDBMapperValueConverter<T>(){

                    @Override
                    public final DynamoDBMapperFieldModel.DynamoDBAttributeType getDynamoDBAttributeType() {
                        return StandardAttributeTypes.AttributeType.L.getDynamoDBAttributeType();
                    }

                    @Override
                    public final AttributeValue convert(T o) {
                        return StandardAttributeTypes.AttributeType.L.converter().convert(o);
                    }

                    @Override
                    public final T unconvert(AttributeValue o) {
                        if (o.getL() == null && o.getNS() != null) {
                            DynamoDBTypeConverter target = StandardTypeConverters.Scalar.BOOLEAN.getConverter(String.class);
                            DynamoDBMapperValueConverter source = StandardAttributeTypes.AttributeType.BOOL.converter();
                            return StandardTypeConverters.Vector.convert(StandardTypeConverters.Vector.convert(o.getNS(), target), source);
                        }
                        return StandardAttributeTypes.AttributeType.L.converter().unconvert(o);
                    }
                }, StandardTypeConverters.Vector.SET.wrap(StandardAttributeTypes.AttributeType.NULL.wrap(StandardAttributeTypes.AttributeType.BOOL.converter()))));
                this.sets.with(Object.class, StandardAttributeTypes.AttributeType.L.converter());
            }
            return this;
        }
    }

    private static final class SchemaFactory
    implements DynamoDBMapperModelFactory {
        private final ConcurrentMap<Class<?>, DynamoDBMapperTableModel<?>> cache = new ConcurrentHashMap();
        private final DynamoDBMapperConfig config;
        private final Conversions conversions;
        private final ItemConverter converter;

        private SchemaFactory(DynamoDBMapperConfig config, ConversionSchema schema, ConversionSchema.Dependencies depends) {
            this.conversions = new Conversions(this).with(depends).with(schema);
            this.converter = schema.getConverter(depends);
            this.config = config;
        }

        @Override
        public <T> DynamoDBMapperTableModel<T> getTableModel(Class<T> targetType) {
            if (!this.cache.containsKey(targetType)) {
                this.cache.putIfAbsent(targetType, this.newTableModel(targetType));
            }
            return (DynamoDBMapperTableModel)this.cache.get(targetType);
        }

        private <T> DynamoDBMapperTableModel<T> newTableModel(Class<T> targetType) {
            StandardAnnotationMaps.TableMap<T> annotations = StandardAnnotationMaps.of(targetType);
            DynamoDBMapperTableModel.Builder<T> table = new DynamoDBMapperTableModel.Builder<T>(annotations);
            if (annotations.tableName() != null) {
                table.withTableName(this.config.getTableNameResolver(true).getTableName(targetType, this.config));
            }
            for (StandardBeanProperties.Bean bean : StandardBeanProperties.of(targetType).values()) {
                DynamoDBMapperFieldModel.Builder field = new DynamoDBMapperFieldModel.Builder(bean.id(), bean.annotations());
                field.with(this.newConverter(bean));
                field.with(bean.reflect());
                table.with(field.build());
            }
            return table.build();
        }

        private <T> DynamoDBMapperValueConverter<T> newConverter(final StandardBeanProperties.Bean<?, T> bean) {
            if (bean.annotations().typeConverted() != null) {
                DynamoDBTypeConverter target = bean.annotations().typeConverter();
                StandardParameterTypes.ParamType<T> type = StandardParameterTypes.of(target);
                return StandardAttributeTypes.join(this.conversions.getConverter(type), target);
            }
            return new DynamoDBMapperValueConverter<T>(){

                @Override
                public final DynamoDBMapperFieldModel.DynamoDBAttributeType getDynamoDBAttributeType() {
                    return SchemaFactory.this.converter.getFieldModel(bean.getter()).getDynamoDBAttributeType();
                }

                @Override
                public final AttributeValue convert(T object) {
                    return SchemaFactory.this.converter.convert(bean.getter(), object);
                }

                @Override
                public final T unconvert(AttributeValue object) {
                    return SchemaFactory.this.converter.unconvert(bean.getter(), bean.setter(), object);
                }
            };
        }
    }

    private static final class SchemaFactoryFactory
    implements DynamoDBMapperModelFactory.Factory {
        private final ConcurrentMap<ConversionSchema, DynamoDBMapperModelFactory> cache = new ConcurrentHashMap<ConversionSchema, DynamoDBMapperModelFactory>();
        private final ConversionSchema.Dependencies depends;

        private SchemaFactoryFactory(ConversionSchema.Dependencies depends) {
            this.depends = depends;
        }

        @Override
        public DynamoDBMapperModelFactory getModelFactory(DynamoDBMapperConfig config) {
            ConversionSchema schema = config.getConversionSchema();
            if (!this.cache.containsKey(schema)) {
                this.cache.putIfAbsent(schema, new SchemaFactory(config, schema, this.depends));
            }
            return (DynamoDBMapperModelFactory)this.cache.get(schema);
        }
    }
}

