/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.GameProperty;
import com.amazonaws.services.gamelift.model.GameSession;
import com.amazonaws.services.gamelift.model.transform.GamePropertyJsonMarshaller;
import java.util.List;

public class GameSessionJsonMarshaller {
    private static GameSessionJsonMarshaller instance;

    public void marshall(GameSession gameSession, StructuredJsonGenerator jsonGenerator) {
        if (gameSession == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<GameProperty> gamePropertiesList;
            jsonGenerator.writeStartObject();
            if (gameSession.getGameSessionId() != null) {
                jsonGenerator.writeFieldName("GameSessionId").writeValue(gameSession.getGameSessionId());
            }
            if (gameSession.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(gameSession.getName());
            }
            if (gameSession.getFleetId() != null) {
                jsonGenerator.writeFieldName("FleetId").writeValue(gameSession.getFleetId());
            }
            if (gameSession.getCreationTime() != null) {
                jsonGenerator.writeFieldName("CreationTime").writeValue(gameSession.getCreationTime());
            }
            if (gameSession.getTerminationTime() != null) {
                jsonGenerator.writeFieldName("TerminationTime").writeValue(gameSession.getTerminationTime());
            }
            if (gameSession.getCurrentPlayerSessionCount() != null) {
                jsonGenerator.writeFieldName("CurrentPlayerSessionCount").writeValue(gameSession.getCurrentPlayerSessionCount());
            }
            if (gameSession.getMaximumPlayerSessionCount() != null) {
                jsonGenerator.writeFieldName("MaximumPlayerSessionCount").writeValue(gameSession.getMaximumPlayerSessionCount());
            }
            if (gameSession.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(gameSession.getStatus());
            }
            if ((gamePropertiesList = gameSession.getGameProperties()) != null) {
                jsonGenerator.writeFieldName("GameProperties");
                jsonGenerator.writeStartArray();
                for (GameProperty gamePropertiesListValue : gamePropertiesList) {
                    if (gamePropertiesListValue == null) continue;
                    GamePropertyJsonMarshaller.getInstance().marshall(gamePropertiesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (gameSession.getIpAddress() != null) {
                jsonGenerator.writeFieldName("IpAddress").writeValue(gameSession.getIpAddress());
            }
            if (gameSession.getPort() != null) {
                jsonGenerator.writeFieldName("Port").writeValue(gameSession.getPort());
            }
            if (gameSession.getPlayerSessionCreationPolicy() != null) {
                jsonGenerator.writeFieldName("PlayerSessionCreationPolicy").writeValue(gameSession.getPlayerSessionCreationPolicy());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GameSessionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GameSessionJsonMarshaller();
        }
        return instance;
    }
}

