/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.State;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class VpcEndpoint
implements Serializable,
Cloneable {
    private Date creationTimestamp;
    private String policyDocument;
    private SdkInternalList<String> routeTableIds;
    private String serviceName;
    private String state;
    private String vpcEndpointId;
    private String vpcId;

    public void setCreationTimestamp(Date creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public Date getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public VpcEndpoint withCreationTimestamp(Date creationTimestamp) {
        this.setCreationTimestamp(creationTimestamp);
        return this;
    }

    public void setPolicyDocument(String policyDocument) {
        this.policyDocument = policyDocument;
    }

    public String getPolicyDocument() {
        return this.policyDocument;
    }

    public VpcEndpoint withPolicyDocument(String policyDocument) {
        this.setPolicyDocument(policyDocument);
        return this;
    }

    public List<String> getRouteTableIds() {
        if (this.routeTableIds == null) {
            this.routeTableIds = new SdkInternalList();
        }
        return this.routeTableIds;
    }

    public void setRouteTableIds(Collection<String> routeTableIds) {
        if (routeTableIds == null) {
            this.routeTableIds = null;
            return;
        }
        this.routeTableIds = new SdkInternalList<String>(routeTableIds);
    }

    public VpcEndpoint withRouteTableIds(String ... routeTableIds) {
        if (this.routeTableIds == null) {
            this.setRouteTableIds(new SdkInternalList<String>(routeTableIds.length));
        }
        for (String ele : routeTableIds) {
            this.routeTableIds.add(ele);
        }
        return this;
    }

    public VpcEndpoint withRouteTableIds(Collection<String> routeTableIds) {
        this.setRouteTableIds(routeTableIds);
        return this;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public VpcEndpoint withServiceName(String serviceName) {
        this.setServiceName(serviceName);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    @JsonProperty(value="state")
    public String getState() {
        return this.state;
    }

    public VpcEndpoint withState(String state) {
        this.setState(state);
        return this;
    }

    @JsonIgnore
    public void setState(State state) {
        this.withState(state);
    }

    public VpcEndpoint withState(State state) {
        this.state = state.toString();
        return this;
    }

    public void setVpcEndpointId(String vpcEndpointId) {
        this.vpcEndpointId = vpcEndpointId;
    }

    public String getVpcEndpointId() {
        return this.vpcEndpointId;
    }

    public VpcEndpoint withVpcEndpointId(String vpcEndpointId) {
        this.setVpcEndpointId(vpcEndpointId);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public VpcEndpoint withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCreationTimestamp() != null) {
            sb.append("CreationTimestamp: ").append(this.getCreationTimestamp()).append(",");
        }
        if (this.getPolicyDocument() != null) {
            sb.append("PolicyDocument: ").append(this.getPolicyDocument()).append(",");
        }
        if (this.getRouteTableIds() != null) {
            sb.append("RouteTableIds: ").append(this.getRouteTableIds()).append(",");
        }
        if (this.getServiceName() != null) {
            sb.append("ServiceName: ").append(this.getServiceName()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getVpcEndpointId() != null) {
            sb.append("VpcEndpointId: ").append(this.getVpcEndpointId()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpoint)) {
            return false;
        }
        VpcEndpoint other = (VpcEndpoint)obj;
        if (other.getCreationTimestamp() == null ^ this.getCreationTimestamp() == null) {
            return false;
        }
        if (other.getCreationTimestamp() != null && !other.getCreationTimestamp().equals(this.getCreationTimestamp())) {
            return false;
        }
        if (other.getPolicyDocument() == null ^ this.getPolicyDocument() == null) {
            return false;
        }
        if (other.getPolicyDocument() != null && !other.getPolicyDocument().equals(this.getPolicyDocument())) {
            return false;
        }
        if (other.getRouteTableIds() == null ^ this.getRouteTableIds() == null) {
            return false;
        }
        if (other.getRouteTableIds() != null && !other.getRouteTableIds().equals(this.getRouteTableIds())) {
            return false;
        }
        if (other.getServiceName() == null ^ this.getServiceName() == null) {
            return false;
        }
        if (other.getServiceName() != null && !other.getServiceName().equals(this.getServiceName())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getVpcEndpointId() == null ^ this.getVpcEndpointId() == null) {
            return false;
        }
        if (other.getVpcEndpointId() != null && !other.getVpcEndpointId().equals(this.getVpcEndpointId())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        return other.getVpcId() == null || other.getVpcId().equals(this.getVpcId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCreationTimestamp() == null ? 0 : this.getCreationTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyDocument() == null ? 0 : this.getPolicyDocument().hashCode());
        hashCode = 31 * hashCode + (this.getRouteTableIds() == null ? 0 : this.getRouteTableIds().hashCode());
        hashCode = 31 * hashCode + (this.getServiceName() == null ? 0 : this.getServiceName().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getVpcEndpointId() == null ? 0 : this.getVpcEndpointId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        return hashCode;
    }

    public VpcEndpoint clone() {
        try {
            return (VpcEndpoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

