/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Tenancy;
import com.amazonaws.services.ec2.model.transform.CreateVpcRequestMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;

public class CreateVpcRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateVpcRequest> {
    private String cidrBlock;
    private Boolean amazonProvidedIpv6CidrBlock;
    private String instanceTenancy;

    public CreateVpcRequest() {
    }

    public CreateVpcRequest(String cidrBlock) {
        this.setCidrBlock(cidrBlock);
    }

    public void setCidrBlock(String cidrBlock) {
        this.cidrBlock = cidrBlock;
    }

    public String getCidrBlock() {
        return this.cidrBlock;
    }

    public CreateVpcRequest withCidrBlock(String cidrBlock) {
        this.setCidrBlock(cidrBlock);
        return this;
    }

    public void setAmazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
        this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
    }

    public Boolean getAmazonProvidedIpv6CidrBlock() {
        return this.amazonProvidedIpv6CidrBlock;
    }

    public CreateVpcRequest withAmazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
        this.setAmazonProvidedIpv6CidrBlock(amazonProvidedIpv6CidrBlock);
        return this;
    }

    public Boolean isAmazonProvidedIpv6CidrBlock() {
        return this.amazonProvidedIpv6CidrBlock;
    }

    public void setInstanceTenancy(String instanceTenancy) {
        this.instanceTenancy = instanceTenancy;
    }

    @JsonProperty(value="instanceTenancy")
    public String getInstanceTenancy() {
        return this.instanceTenancy;
    }

    public CreateVpcRequest withInstanceTenancy(String instanceTenancy) {
        this.setInstanceTenancy(instanceTenancy);
        return this;
    }

    @JsonIgnore
    public void setInstanceTenancy(Tenancy instanceTenancy) {
        this.withInstanceTenancy(instanceTenancy);
    }

    public CreateVpcRequest withInstanceTenancy(Tenancy instanceTenancy) {
        this.instanceTenancy = instanceTenancy.toString();
        return this;
    }

    @Override
    public Request<CreateVpcRequest> getDryRunRequest() {
        Request<CreateVpcRequest> request = new CreateVpcRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCidrBlock() != null) {
            sb.append("CidrBlock: ").append(this.getCidrBlock()).append(",");
        }
        if (this.getAmazonProvidedIpv6CidrBlock() != null) {
            sb.append("AmazonProvidedIpv6CidrBlock: ").append(this.getAmazonProvidedIpv6CidrBlock()).append(",");
        }
        if (this.getInstanceTenancy() != null) {
            sb.append("InstanceTenancy: ").append(this.getInstanceTenancy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcRequest)) {
            return false;
        }
        CreateVpcRequest other = (CreateVpcRequest)obj;
        if (other.getCidrBlock() == null ^ this.getCidrBlock() == null) {
            return false;
        }
        if (other.getCidrBlock() != null && !other.getCidrBlock().equals(this.getCidrBlock())) {
            return false;
        }
        if (other.getAmazonProvidedIpv6CidrBlock() == null ^ this.getAmazonProvidedIpv6CidrBlock() == null) {
            return false;
        }
        if (other.getAmazonProvidedIpv6CidrBlock() != null && !other.getAmazonProvidedIpv6CidrBlock().equals(this.getAmazonProvidedIpv6CidrBlock())) {
            return false;
        }
        if (other.getInstanceTenancy() == null ^ this.getInstanceTenancy() == null) {
            return false;
        }
        return other.getInstanceTenancy() == null || other.getInstanceTenancy().equals(this.getInstanceTenancy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCidrBlock() == null ? 0 : this.getCidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.getAmazonProvidedIpv6CidrBlock() == null ? 0 : this.getAmazonProvidedIpv6CidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceTenancy() == null ? 0 : this.getInstanceTenancy().hashCode());
        return hashCode;
    }

    @Override
    public CreateVpcRequest clone() {
        return (CreateVpcRequest)super.clone();
    }
}

