/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.ActionConfiguration;
import java.util.Map;

public class ActionConfigurationJsonMarshaller {
    private static ActionConfigurationJsonMarshaller instance;

    public void marshall(ActionConfiguration actionConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (actionConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            Map<String, String> configurationMap = actionConfiguration.getConfiguration();
            if (configurationMap != null) {
                jsonGenerator.writeFieldName("configuration");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> configurationMapValue : configurationMap.entrySet()) {
                    if (configurationMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(configurationMapValue.getKey());
                    jsonGenerator.writeValue(configurationMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ActionConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ActionConfigurationJsonMarshaller();
        }
        return instance;
    }
}

