/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.servicecatalog.model.ProductViewSortBy;
import com.amazonaws.services.servicecatalog.model.SortOrder;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchProductsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String acceptLanguage;
    private Map<String, List<String>> filters;
    private Integer pageSize;
    private String sortBy;
    private String sortOrder;
    private String pageToken;

    public void setAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public SearchProductsRequest withAcceptLanguage(String acceptLanguage) {
        this.setAcceptLanguage(acceptLanguage);
        return this;
    }

    public Map<String, List<String>> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, List<String>> filters) {
        this.filters = filters;
    }

    public SearchProductsRequest withFilters(Map<String, List<String>> filters) {
        this.setFilters(filters);
        return this;
    }

    public SearchProductsRequest addFiltersEntry(String key, List<String> value) {
        if (null == this.filters) {
            this.filters = new HashMap<String, List<String>>();
        }
        if (this.filters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.filters.put(key, value);
        return this;
    }

    public SearchProductsRequest clearFiltersEntries() {
        this.filters = null;
        return this;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public SearchProductsRequest withPageSize(Integer pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public SearchProductsRequest withSortBy(String sortBy) {
        this.setSortBy(sortBy);
        return this;
    }

    public void setSortBy(ProductViewSortBy sortBy) {
        this.sortBy = sortBy.toString();
    }

    public SearchProductsRequest withSortBy(ProductViewSortBy sortBy) {
        this.setSortBy(sortBy);
        return this;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public SearchProductsRequest withSortOrder(String sortOrder) {
        this.setSortOrder(sortOrder);
        return this;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder.toString();
    }

    public SearchProductsRequest withSortOrder(SortOrder sortOrder) {
        this.setSortOrder(sortOrder);
        return this;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public SearchProductsRequest withPageToken(String pageToken) {
        this.setPageToken(pageToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAcceptLanguage() != null) {
            sb.append("AcceptLanguage: " + this.getAcceptLanguage() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters() + ",");
        }
        if (this.getPageSize() != null) {
            sb.append("PageSize: " + this.getPageSize() + ",");
        }
        if (this.getSortBy() != null) {
            sb.append("SortBy: " + this.getSortBy() + ",");
        }
        if (this.getSortOrder() != null) {
            sb.append("SortOrder: " + this.getSortOrder() + ",");
        }
        if (this.getPageToken() != null) {
            sb.append("PageToken: " + this.getPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProductsRequest)) {
            return false;
        }
        SearchProductsRequest other = (SearchProductsRequest)obj;
        if (other.getAcceptLanguage() == null ^ this.getAcceptLanguage() == null) {
            return false;
        }
        if (other.getAcceptLanguage() != null && !other.getAcceptLanguage().equals(this.getAcceptLanguage())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getPageSize() == null ^ this.getPageSize() == null) {
            return false;
        }
        if (other.getPageSize() != null && !other.getPageSize().equals(this.getPageSize())) {
            return false;
        }
        if (other.getSortBy() == null ^ this.getSortBy() == null) {
            return false;
        }
        if (other.getSortBy() != null && !other.getSortBy().equals(this.getSortBy())) {
            return false;
        }
        if (other.getSortOrder() == null ^ this.getSortOrder() == null) {
            return false;
        }
        if (other.getSortOrder() != null && !other.getSortOrder().equals(this.getSortOrder())) {
            return false;
        }
        if (other.getPageToken() == null ^ this.getPageToken() == null) {
            return false;
        }
        return other.getPageToken() == null || other.getPageToken().equals(this.getPageToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAcceptLanguage() == null ? 0 : this.getAcceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getPageSize() == null ? 0 : this.getPageSize().hashCode());
        hashCode = 31 * hashCode + (this.getSortBy() == null ? 0 : this.getSortBy().hashCode());
        hashCode = 31 * hashCode + (this.getSortOrder() == null ? 0 : this.getSortOrder().hashCode());
        hashCode = 31 * hashCode + (this.getPageToken() == null ? 0 : this.getPageToken().hashCode());
        return hashCode;
    }

    @Override
    public SearchProductsRequest clone() {
        return (SearchProductsRequest)super.clone();
    }
}

