/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.lambda.model.ListAliasesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListAliasesRequestMarshaller
implements Marshaller<Request<ListAliasesRequest>, ListAliasesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListAliasesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListAliasesRequest> marshall(ListAliasesRequest listAliasesRequest) {
        if (listAliasesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListAliasesRequest> request = new DefaultRequest<ListAliasesRequest>(listAliasesRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/aliases";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", listAliasesRequest.getFunctionName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(listAliasesRequest.getFunctionName()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (listAliasesRequest.getFunctionVersion() != null) {
            request.addParameter("FunctionVersion", StringUtils.fromString(listAliasesRequest.getFunctionVersion()));
        }
        if (listAliasesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listAliasesRequest.getMarker()));
        }
        if (listAliasesRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger(listAliasesRequest.getMaxItems()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

