/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.Application;
import com.amazonaws.services.elasticmapreduce.model.ClusterStatus;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.services.elasticmapreduce.model.Ec2InstanceAttributes;
import com.amazonaws.services.elasticmapreduce.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Cluster
implements Serializable,
Cloneable {
    private String id;
    private String name;
    private ClusterStatus status;
    private Ec2InstanceAttributes ec2InstanceAttributes;
    private String logUri;
    private String requestedAmiVersion;
    private String runningAmiVersion;
    private String releaseLabel;
    private Boolean autoTerminate;
    private Boolean terminationProtected;
    private Boolean visibleToAllUsers;
    private SdkInternalList<Application> applications;
    private SdkInternalList<Tag> tags;
    private String serviceRole;
    private Integer normalizedInstanceHours;
    private String masterPublicDnsName;
    private SdkInternalList<Configuration> configurations;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Cluster withId(String id) {
        this.setId(id);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Cluster withName(String name) {
        this.setName(name);
        return this;
    }

    public void setStatus(ClusterStatus status) {
        this.status = status;
    }

    public ClusterStatus getStatus() {
        return this.status;
    }

    public Cluster withStatus(ClusterStatus status) {
        this.setStatus(status);
        return this;
    }

    public void setEc2InstanceAttributes(Ec2InstanceAttributes ec2InstanceAttributes) {
        this.ec2InstanceAttributes = ec2InstanceAttributes;
    }

    public Ec2InstanceAttributes getEc2InstanceAttributes() {
        return this.ec2InstanceAttributes;
    }

    public Cluster withEc2InstanceAttributes(Ec2InstanceAttributes ec2InstanceAttributes) {
        this.setEc2InstanceAttributes(ec2InstanceAttributes);
        return this;
    }

    public void setLogUri(String logUri) {
        this.logUri = logUri;
    }

    public String getLogUri() {
        return this.logUri;
    }

    public Cluster withLogUri(String logUri) {
        this.setLogUri(logUri);
        return this;
    }

    public void setRequestedAmiVersion(String requestedAmiVersion) {
        this.requestedAmiVersion = requestedAmiVersion;
    }

    public String getRequestedAmiVersion() {
        return this.requestedAmiVersion;
    }

    public Cluster withRequestedAmiVersion(String requestedAmiVersion) {
        this.setRequestedAmiVersion(requestedAmiVersion);
        return this;
    }

    public void setRunningAmiVersion(String runningAmiVersion) {
        this.runningAmiVersion = runningAmiVersion;
    }

    public String getRunningAmiVersion() {
        return this.runningAmiVersion;
    }

    public Cluster withRunningAmiVersion(String runningAmiVersion) {
        this.setRunningAmiVersion(runningAmiVersion);
        return this;
    }

    public void setReleaseLabel(String releaseLabel) {
        this.releaseLabel = releaseLabel;
    }

    public String getReleaseLabel() {
        return this.releaseLabel;
    }

    public Cluster withReleaseLabel(String releaseLabel) {
        this.setReleaseLabel(releaseLabel);
        return this;
    }

    public void setAutoTerminate(Boolean autoTerminate) {
        this.autoTerminate = autoTerminate;
    }

    public Boolean getAutoTerminate() {
        return this.autoTerminate;
    }

    public Cluster withAutoTerminate(Boolean autoTerminate) {
        this.setAutoTerminate(autoTerminate);
        return this;
    }

    public Boolean isAutoTerminate() {
        return this.autoTerminate;
    }

    public void setTerminationProtected(Boolean terminationProtected) {
        this.terminationProtected = terminationProtected;
    }

    public Boolean getTerminationProtected() {
        return this.terminationProtected;
    }

    public Cluster withTerminationProtected(Boolean terminationProtected) {
        this.setTerminationProtected(terminationProtected);
        return this;
    }

    public Boolean isTerminationProtected() {
        return this.terminationProtected;
    }

    public void setVisibleToAllUsers(Boolean visibleToAllUsers) {
        this.visibleToAllUsers = visibleToAllUsers;
    }

    public Boolean getVisibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public Cluster withVisibleToAllUsers(Boolean visibleToAllUsers) {
        this.setVisibleToAllUsers(visibleToAllUsers);
        return this;
    }

    public Boolean isVisibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public List<Application> getApplications() {
        if (this.applications == null) {
            this.applications = new SdkInternalList();
        }
        return this.applications;
    }

    public void setApplications(Collection<Application> applications) {
        if (applications == null) {
            this.applications = null;
            return;
        }
        this.applications = new SdkInternalList<Application>(applications);
    }

    public Cluster withApplications(Application ... applications) {
        if (this.applications == null) {
            this.setApplications(new SdkInternalList<Application>(applications.length));
        }
        for (Application ele : applications) {
            this.applications.add(ele);
        }
        return this;
    }

    public Cluster withApplications(Collection<Application> applications) {
        this.setApplications(applications);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public Cluster withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Cluster withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setServiceRole(String serviceRole) {
        this.serviceRole = serviceRole;
    }

    public String getServiceRole() {
        return this.serviceRole;
    }

    public Cluster withServiceRole(String serviceRole) {
        this.setServiceRole(serviceRole);
        return this;
    }

    public void setNormalizedInstanceHours(Integer normalizedInstanceHours) {
        this.normalizedInstanceHours = normalizedInstanceHours;
    }

    public Integer getNormalizedInstanceHours() {
        return this.normalizedInstanceHours;
    }

    public Cluster withNormalizedInstanceHours(Integer normalizedInstanceHours) {
        this.setNormalizedInstanceHours(normalizedInstanceHours);
        return this;
    }

    public void setMasterPublicDnsName(String masterPublicDnsName) {
        this.masterPublicDnsName = masterPublicDnsName;
    }

    public String getMasterPublicDnsName() {
        return this.masterPublicDnsName;
    }

    public Cluster withMasterPublicDnsName(String masterPublicDnsName) {
        this.setMasterPublicDnsName(masterPublicDnsName);
        return this;
    }

    public List<Configuration> getConfigurations() {
        if (this.configurations == null) {
            this.configurations = new SdkInternalList();
        }
        return this.configurations;
    }

    public void setConfigurations(Collection<Configuration> configurations) {
        if (configurations == null) {
            this.configurations = null;
            return;
        }
        this.configurations = new SdkInternalList<Configuration>(configurations);
    }

    public Cluster withConfigurations(Configuration ... configurations) {
        if (this.configurations == null) {
            this.setConfigurations(new SdkInternalList<Configuration>(configurations.length));
        }
        for (Configuration ele : configurations) {
            this.configurations.add(ele);
        }
        return this;
    }

    public Cluster withConfigurations(Collection<Configuration> configurations) {
        this.setConfigurations(configurations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: " + this.getId() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getEc2InstanceAttributes() != null) {
            sb.append("Ec2InstanceAttributes: " + this.getEc2InstanceAttributes() + ",");
        }
        if (this.getLogUri() != null) {
            sb.append("LogUri: " + this.getLogUri() + ",");
        }
        if (this.getRequestedAmiVersion() != null) {
            sb.append("RequestedAmiVersion: " + this.getRequestedAmiVersion() + ",");
        }
        if (this.getRunningAmiVersion() != null) {
            sb.append("RunningAmiVersion: " + this.getRunningAmiVersion() + ",");
        }
        if (this.getReleaseLabel() != null) {
            sb.append("ReleaseLabel: " + this.getReleaseLabel() + ",");
        }
        if (this.getAutoTerminate() != null) {
            sb.append("AutoTerminate: " + this.getAutoTerminate() + ",");
        }
        if (this.getTerminationProtected() != null) {
            sb.append("TerminationProtected: " + this.getTerminationProtected() + ",");
        }
        if (this.getVisibleToAllUsers() != null) {
            sb.append("VisibleToAllUsers: " + this.getVisibleToAllUsers() + ",");
        }
        if (this.getApplications() != null) {
            sb.append("Applications: " + this.getApplications() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getServiceRole() != null) {
            sb.append("ServiceRole: " + this.getServiceRole() + ",");
        }
        if (this.getNormalizedInstanceHours() != null) {
            sb.append("NormalizedInstanceHours: " + this.getNormalizedInstanceHours() + ",");
        }
        if (this.getMasterPublicDnsName() != null) {
            sb.append("MasterPublicDnsName: " + this.getMasterPublicDnsName() + ",");
        }
        if (this.getConfigurations() != null) {
            sb.append("Configurations: " + this.getConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getEc2InstanceAttributes() == null ^ this.getEc2InstanceAttributes() == null) {
            return false;
        }
        if (other.getEc2InstanceAttributes() != null && !other.getEc2InstanceAttributes().equals(this.getEc2InstanceAttributes())) {
            return false;
        }
        if (other.getLogUri() == null ^ this.getLogUri() == null) {
            return false;
        }
        if (other.getLogUri() != null && !other.getLogUri().equals(this.getLogUri())) {
            return false;
        }
        if (other.getRequestedAmiVersion() == null ^ this.getRequestedAmiVersion() == null) {
            return false;
        }
        if (other.getRequestedAmiVersion() != null && !other.getRequestedAmiVersion().equals(this.getRequestedAmiVersion())) {
            return false;
        }
        if (other.getRunningAmiVersion() == null ^ this.getRunningAmiVersion() == null) {
            return false;
        }
        if (other.getRunningAmiVersion() != null && !other.getRunningAmiVersion().equals(this.getRunningAmiVersion())) {
            return false;
        }
        if (other.getReleaseLabel() == null ^ this.getReleaseLabel() == null) {
            return false;
        }
        if (other.getReleaseLabel() != null && !other.getReleaseLabel().equals(this.getReleaseLabel())) {
            return false;
        }
        if (other.getAutoTerminate() == null ^ this.getAutoTerminate() == null) {
            return false;
        }
        if (other.getAutoTerminate() != null && !other.getAutoTerminate().equals(this.getAutoTerminate())) {
            return false;
        }
        if (other.getTerminationProtected() == null ^ this.getTerminationProtected() == null) {
            return false;
        }
        if (other.getTerminationProtected() != null && !other.getTerminationProtected().equals(this.getTerminationProtected())) {
            return false;
        }
        if (other.getVisibleToAllUsers() == null ^ this.getVisibleToAllUsers() == null) {
            return false;
        }
        if (other.getVisibleToAllUsers() != null && !other.getVisibleToAllUsers().equals(this.getVisibleToAllUsers())) {
            return false;
        }
        if (other.getApplications() == null ^ this.getApplications() == null) {
            return false;
        }
        if (other.getApplications() != null && !other.getApplications().equals(this.getApplications())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getServiceRole() == null ^ this.getServiceRole() == null) {
            return false;
        }
        if (other.getServiceRole() != null && !other.getServiceRole().equals(this.getServiceRole())) {
            return false;
        }
        if (other.getNormalizedInstanceHours() == null ^ this.getNormalizedInstanceHours() == null) {
            return false;
        }
        if (other.getNormalizedInstanceHours() != null && !other.getNormalizedInstanceHours().equals(this.getNormalizedInstanceHours())) {
            return false;
        }
        if (other.getMasterPublicDnsName() == null ^ this.getMasterPublicDnsName() == null) {
            return false;
        }
        if (other.getMasterPublicDnsName() != null && !other.getMasterPublicDnsName().equals(this.getMasterPublicDnsName())) {
            return false;
        }
        if (other.getConfigurations() == null ^ this.getConfigurations() == null) {
            return false;
        }
        return other.getConfigurations() == null || other.getConfigurations().equals(this.getConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getEc2InstanceAttributes() == null ? 0 : this.getEc2InstanceAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getLogUri() == null ? 0 : this.getLogUri().hashCode());
        hashCode = 31 * hashCode + (this.getRequestedAmiVersion() == null ? 0 : this.getRequestedAmiVersion().hashCode());
        hashCode = 31 * hashCode + (this.getRunningAmiVersion() == null ? 0 : this.getRunningAmiVersion().hashCode());
        hashCode = 31 * hashCode + (this.getReleaseLabel() == null ? 0 : this.getReleaseLabel().hashCode());
        hashCode = 31 * hashCode + (this.getAutoTerminate() == null ? 0 : this.getAutoTerminate().hashCode());
        hashCode = 31 * hashCode + (this.getTerminationProtected() == null ? 0 : this.getTerminationProtected().hashCode());
        hashCode = 31 * hashCode + (this.getVisibleToAllUsers() == null ? 0 : this.getVisibleToAllUsers().hashCode());
        hashCode = 31 * hashCode + (this.getApplications() == null ? 0 : this.getApplications().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRole() == null ? 0 : this.getServiceRole().hashCode());
        hashCode = 31 * hashCode + (this.getNormalizedInstanceHours() == null ? 0 : this.getNormalizedInstanceHours().hashCode());
        hashCode = 31 * hashCode + (this.getMasterPublicDnsName() == null ? 0 : this.getMasterPublicDnsName().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurations() == null ? 0 : this.getConfigurations().hashCode());
        return hashCode;
    }

    public Cluster clone() {
        try {
            return (Cluster)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

