/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.transfer.TransferManager;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class S3ClientCache {
    private final ConcurrentMap<Region, AmazonS3> clientsByRegion = new ConcurrentHashMap<Region, AmazonS3>();
    private final Map<Region, TransferManager> transferManagersByRegion = new EnumMap<Region, TransferManager>(Region.class);
    private final AWSCredentialsProvider awscredentialsProvider;

    @Deprecated
    S3ClientCache(AWSCredentials credentials) {
        this(new StaticCredentialsProvider(credentials));
    }

    S3ClientCache(AWSCredentialsProvider awsCredentialsProvider) {
        this.awscredentialsProvider = awsCredentialsProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useClient(AmazonS3 client) {
        Region s3region = client.getRegion();
        Map<Region, TransferManager> map = this.transferManagersByRegion;
        synchronized (map) {
            TransferManager tm = this.transferManagersByRegion.remove((Object)s3region);
            if (tm != null) {
                tm.shutdownNow();
            }
            this.clientsByRegion.put(s3region, client);
        }
    }

    public AmazonS3 getClient(Region s3region) {
        if (s3region == null) {
            throw new IllegalArgumentException("S3 region must be specified");
        }
        AmazonS3 client = (AmazonS3)this.clientsByRegion.get((Object)s3region);
        return client != null ? client : this.cacheClient(s3region);
    }

    private AmazonS3 cacheClient(Region s3region) {
        if (this.awscredentialsProvider == null) {
            throw new IllegalArgumentException("No credentials provider found to connect to S3");
        }
        AmazonS3Client client = new AmazonS3Client(this.awscredentialsProvider);
        client.setRegion(s3region.toAWSRegion());
        this.clientsByRegion.put(s3region, client);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferManager getTransferManager(Region region) {
        Map<Region, TransferManager> map = this.transferManagersByRegion;
        synchronized (map) {
            TransferManager tm = this.transferManagersByRegion.get((Object)region);
            if (tm == null) {
                tm = new TransferManager(this.getClient(region));
                this.transferManagersByRegion.put(region, tm);
            }
            return tm;
        }
    }
}

