/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.opsworks.model.BlockDeviceMapping;

@SdkInternalApi
public class BlockDeviceMappingMarshaller {
    private static final MarshallingInfo<String> DEVICENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceName").build();
    private static final MarshallingInfo<String> NODEVICE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NoDevice").build();
    private static final MarshallingInfo<String> VIRTUALNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VirtualName").build();
    private static final MarshallingInfo<StructuredPojo> EBS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ebs").build();
    private static final BlockDeviceMappingMarshaller instance = new BlockDeviceMappingMarshaller();

    public static BlockDeviceMappingMarshaller getInstance() {
        return instance;
    }

    public void marshall(BlockDeviceMapping blockDeviceMapping, ProtocolMarshaller protocolMarshaller) {
        if (blockDeviceMapping == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(blockDeviceMapping.getDeviceName(), DEVICENAME_BINDING);
            protocolMarshaller.marshall(blockDeviceMapping.getNoDevice(), NODEVICE_BINDING);
            protocolMarshaller.marshall(blockDeviceMapping.getVirtualName(), VIRTUALNAME_BINDING);
            protocolMarshaller.marshall(blockDeviceMapping.getEbs(), EBS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

