/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.DescribeStaleSecurityGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeStaleSecurityGroupsRequestMarshaller
implements Marshaller<Request<DescribeStaleSecurityGroupsRequest>, DescribeStaleSecurityGroupsRequest> {
    @Override
    public Request<DescribeStaleSecurityGroupsRequest> marshall(DescribeStaleSecurityGroupsRequest describeStaleSecurityGroupsRequest) {
        if (describeStaleSecurityGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeStaleSecurityGroupsRequest> request = new DefaultRequest<DescribeStaleSecurityGroupsRequest>(describeStaleSecurityGroupsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeStaleSecurityGroups");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeStaleSecurityGroupsRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString(describeStaleSecurityGroupsRequest.getVpcId()));
        }
        if (describeStaleSecurityGroupsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeStaleSecurityGroupsRequest.getMaxResults()));
        }
        if (describeStaleSecurityGroupsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeStaleSecurityGroupsRequest.getNextToken()));
        }
        return request;
    }
}

