/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.applicationdiscovery.model.ConfigurationItemType;
import com.amazonaws.services.applicationdiscovery.model.Filter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListConfigurationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String configurationType;
    private List<Filter> filters;
    private Integer maxResults;
    private String nextToken;

    public void setConfigurationType(String configurationType) {
        this.configurationType = configurationType;
    }

    public String getConfigurationType() {
        return this.configurationType;
    }

    public ListConfigurationsRequest withConfigurationType(String configurationType) {
        this.setConfigurationType(configurationType);
        return this;
    }

    public void setConfigurationType(ConfigurationItemType configurationType) {
        this.configurationType = configurationType.toString();
    }

    public ListConfigurationsRequest withConfigurationType(ConfigurationItemType configurationType) {
        this.setConfigurationType(configurationType);
        return this;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<Filter>(filters);
    }

    public ListConfigurationsRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public ListConfigurationsRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListConfigurationsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListConfigurationsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfigurationType() != null) {
            sb.append("ConfigurationType: " + this.getConfigurationType() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters() + ",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: " + this.getMaxResults() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationsRequest)) {
            return false;
        }
        ListConfigurationsRequest other = (ListConfigurationsRequest)obj;
        if (other.getConfigurationType() == null ^ this.getConfigurationType() == null) {
            return false;
        }
        if (other.getConfigurationType() != null && !other.getConfigurationType().equals(this.getConfigurationType())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfigurationType() == null ? 0 : this.getConfigurationType().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListConfigurationsRequest clone() {
        return (ListConfigurationsRequest)super.clone();
    }
}

